<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
include('include/navigation.php');

include_once('connection.php');
require_once('class.php');
$dbConnection = new DbConnection();
$connection = $dbConnection->connection;

if (isset($_SESSION["id"])) {
    header("Location: pendingOrder.php");
    exit;
}

$parts = new ConfirmOrder();

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    // Get the values as an array
    $c_uid = $_POST["c_uid"];
    $q_do = $_POST["q_do"];
    $total_amount = $_POST["total_amount"];
    $final_amount = $_POST["final_amount"];
    $amount_receive = $_POST["amount_receive"];
    $payment_mode = $_POST["payment_mode"];
    $date = $_POST["date"];
    $bank_name = $_POST["bank_name"];
    $total_amount_receive = $_POST["total_amount_receive"];
    $pending_amount = $_POST["pending_amount"];
    $d_month = $_POST["d_month"];

    // Serialize the array of "Amount Receive" values
    $serialized_amount_receive = implode(', ', array_values($amount_receive));
    $serialized_payment_mode = implode(', ', array_values($payment_mode));
    $serialized_date = implode(', ', array_values($date));
    $serialized_bank_name = implode(', ', array_values($bank_name));

    // Insert the serialized array into the database
    $result = $parts->Corder($c_uid, $q_do, $total_amount, $final_amount, $serialized_amount_receive, $serialized_payment_mode,$serialized_date,$serialized_bank_name , $total_amount_receive, $pending_amount, $d_month);

    if ($result == 1) {
         $user_id = $_SESSION["user"]['id'];
    $name = $_SESSION["user"]["name"];
    $email = $_SESSION["user"]["email"];
    $roles = $_SESSION["user"]["roles"];
    $action = "Insert";
    $table = "c_order";
    $created_on = date("Y-m-d H:i:s");

    // Query to insert user log into database
    $insert_user_log_query = "INSERT INTO users_log (user_id, name, email, roles, action, tabel, created_on) VALUES (?, ?, ?, ?, ?, ?, ?)";
    $stmt = $connection->prepare($insert_user_log_query);
    $stmt->bind_param("issssss", $user_id, $name, $email, $roles, $action, $table, $created_on);
    $stmt->execute();
    $stmt->close();
        echo "<script> alert('Added Successful'); </script>";
    } elseif ($result == 10) {
        echo "<script> alert('Something is wrong'); </script>";
    }
}

$selectedClientUID = isset($_SESSION['selectedClientUID']) ? $_SESSION['selectedClientUID'] : '';
$selectedQuotation = isset($_SESSION['selectedQuotation']) ? $_SESSION['selectedQuotation'] : '';
$previousAmount = isset($_SESSION['previousAmount']) ? $_SESSION['previousAmount'] : '';

// Clear preserved values from session
unset($_SESSION['selectedClientUID']);
unset($_SESSION['selectedQuotation']);
unset($_SESSION['previousAmount']);

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE-edge">     
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.13.14/dist/css/bootstrap-select.min.css">
     <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <link rel="stylesheet" href="include/css/client_form.css">
    <title>Document</title>
</head>
<script>
function finalAmount() {
    // Get the value from the "Previous Amount" input field
    var previousAmount = document.getElementById("total-amount").value;

    // Remove the "Rs." prefix and set the value to the "final Amount" input field
    document.getElementById("final_amount").value = previousAmount.replace("Rs.", "").trim();
}

</script>
<body>
<div class="container">
    <h2>Confirm Order</h2>
    <form action="" method="POST">
        <label for="name">Client UID:</label>
       
        <select  data-live-search="true" id="name" name="c_uid"  required style="width:100%; height:35px; border-radius:5px;" onchange="enableSecondDropdown();checkChequeStatus()">
            <option value="" style="width:100%; height:35px; border-radius:5px;">--Select C UID--</option>
            <?php
            $option = mysqli_query($connection, "SELECT * FROM clients");
            while ($row = mysqli_fetch_array($option)) {
                echo '<option value="' . $row['u_id'] . '">' . $row['u_id'] . ' - ' . $row['firm_name'] . ' - ' . $row['address'] . '</option>';
            }
            ?>   
        </select>

        <label for="Quotation">Quotation :</label>
        <select id="address" name="q_do" class="text1" style="width:100%; height:35px; border-radius:5px;" disabled required>
            <option value="">--Select Q/Do--</option>
            <?php
            $option = mysqli_query($connection, "SELECT * FROM qsend");
            while ($row = mysqli_fetch_array($option)) {
                echo '<option value="' . $row['product_a'] . '">' . $row['product_a'] . '</option>';
            }
            ?>
        </select>

        <label for="TotalAmount">Previous Amount:</label>
        <input type="text2" id="total-amount" name="total_amount" placeholder="" readonly required>
        
          <button type="button" onclick="editQuotation()">EDIT</button>
          
            <label for="final_amount">final Amount:</label>
            <input type="text1" id="final_amount" name="final_amount" value="" placeholder="" required onfocus="finalAmount()"><br><br>
        
        
            <div id="addmore">
            <label for="AmountReceive"> Amount Received:</label>
            <input type="text" class="amount-receive" name="amount_receive[]" placeholder="" required>
        
            <label for="payment_mode">Payment Mode:</label>
            <select class="payment_mode" name="payment_mode[]" style="width:200px">
                <option>Select Mode</option>
                <option value="CASH">CASH</option>
                <option value="CHEQUE" id="chequeOption">CHEQUE</option>
                <option value="NET BANKING">NET BANKING</option>
            </select>
        
            <label for="date">Date:</label>
           <input type="Date" class="date" data-amount="0" name="date[]" placeholder="" required>
        
        
            <label for="bank_name">Bank Name:</label>
            <input type="text" class="bank_name" name="bank_name[]" data-amount="0" placeholder="" required><br>
        </div>


        <center><button type="button" id="addMoreAmount">Add More</button></center>
        <!--<button type="button" class="removeField">Remove</button>-->
         
        <label for="TotalAmountReceive">Total Amount Received:</label>
        <input type="text1" id="Totalamount-receive" name="total_amount_receive" placeholder="" readonly required><br>

        <label for="pendingAmount"> Pending Amount :</label>
        <input type="text1" id="pendingAmount" name="pending_amount"  placeholder="" required readonly><br>

        <label for="deliveryMonth">Delivery Month:</label>
        <input type="date" id="deliveryMonth" name="d_month" placeholder="" required style:"width:25%"><br>

          <center><input type="submit" name="Confirm" value="submit"></center>
    </form>
    
       <div id="updateForm" class="hidden-form">
         <form action="c_damount_edit.php" method="POST">
              <input type="hidden" id="cuid" name="client_uid"   required>
              <input type="hidden" id="file-name" name="file_name"   required>
              
            <label for="product_price">Product Price:</label>
            <input type="text1" id="product_price" name="product_price" placeholder="Product Price"   required>
            
            <label for="d_amount">Discount Amount:</label>
            <input type="text1" id="d_amount" name="d_amount" placeholder="Discount amount" oninput="calculateTotal()" required>
            
            <label for="gst">GST charge:</label>
            <input type="text1" id="gst" name="gst" placeholder="GST" oninput="calculateTotal()" required>
            
            <label for="packaging">Packaging charge:</label>
            <input type="text1" id="packaging" name="packaging" placeholder="Packaging charge"  oninput="calculateTotal()" required>
            
            <label for="tcs">T.C.S:</label>
            <input type="text1" id="tcs" name="tcs" placeholder="TCS"  oninput="calculateTotal()">
            
            <label for="total_amount">Total Amount:</label>
            <input type="text1" id="total_amount_1" name="total_amount" placeholder="Total Amount" readonly>
           <button type="button" id="hideFormButton" onclick="hideForm()">HIDE</button>
           <button type="submit" name="update">Save</button>
        </form>
        </div>
</div>
<section class="footer">
    <?php include('include/footer_two.php') ?>
</section>
</body>

<?php   include('include/form_footer_link.php'); ?>

<script src="script/nav.js"></script>
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script> 
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.4.0/jspdf.umd.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.14.3/dist/umd/popper.min.js" ></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/js/bootstrap.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.13.14/dist/js/bootstrap-select.min.js"></script>
<script>
     $(document).ready(function(){
        $('#name').selectpicker();
     })
     


 function enableSecondDropdown() {
    var firstDropdown = document.getElementById("name");
    var secondDropdown = document.getElementById("address");

    if (firstDropdown.value !== "") {
        secondDropdown.removeAttribute("disabled");
    } else {
        secondDropdown.setAttribute("disabled", "true");
    }
}

function update_Total_AmountByQuotation(quotation) {
    $.ajax({
        url: 'amount_by_quotation.php',
        type: 'POST',
        data: { quotation: quotation },
        success: function (response) {
            try {
                var data = JSON.parse(response);
                $("#total-amount").val(data.total_amount);
                $("#total_amount_1").val(data.total_amount);
                $("#product_price").val(data.budget);
                $("#d_amount").val(data.d_amount);
                $("#gst").val(data.gst);
                $("#packaging").val(data.packaging);
                $("#tcs").val(data.tcs);
            } catch (e) {
                console.error("Error parsing JSON:", e);
                console.error("Invalid JSON response:", response);
            }
            hideForm(); // Optionally, hide the form
        },
        error: function (xhr, status, error) {
            console.error("AJAX Error:", error);
            console.error("Response Text:", xhr.responseText); // Log the response text
        }
    });
}

// Handle the change event of the "Quotation" dropdown
$(document).ready(function () {
    $('#address').change(function () {
        var selectedQuotation = $(this).val();
        if (selectedQuotation !== "") {
            update_Total_AmountByQuotation(selectedQuotation);
            enableSecondDropdown();
        } else {
            $("#total-amount").val("");
        }
    });
});


$(document).on('input', '.amount-receive', function () {
    updateTotalAmountReceived();
});

// Function to calculate and update the total amount received and pending amount



function extractNumericValue(str) {
    return parseFloat(str.replace(/[^0-9.]/g, '')) || 0;
}

// Function to update total amount received and pending amount
function updateTotalAmountReceived() {
    var totalAmountReceived = 0;

    // Loop through each "Amount Receive" input field and sum the values
    $('.amount-receive').each(function () {
        var value = extractNumericValue($(this).val());
        totalAmountReceived += value;
    });

    // Get the final amount
    var finalAmount = extractNumericValue($('#final_amount').val());

    // Check the prefix of final amount and set the prefix for total amount received and pending amount
    var prefix = ($('#final_amount').val().includes('Rs')) ? 'Rs ' : '$ ';

    // Update the total amount received field
    $('#Totalamount-receive').val(prefix + totalAmountReceived.toFixed(2));

    // Calculate pending amount
    var pendingAmount = finalAmount - totalAmountReceived;

    // Update the pending amount field
    $('#pendingAmount').val(prefix + pendingAmount.toFixed(2));
}

// Event listener for input fields
$(document).on('input', '.amount-receive', function () {
    updateTotalAmountReceived()
});

// Function to update the final amount field and trigger updateAmounts()
function finalAmount() {
    var previousAmount = extractNumericValue(document.getElementById("total-amount").value);
    var prefix = (document.getElementById("total-amount").value.includes('Rs')) ? 'Rs ' : '$ ';
    $('#final_amount').val(prefix + previousAmount.toFixed(2));
     updateTotalAmountReceived()
}

// Initial call to updateAmounts() on page load
$(document).ready(function () {
      updateTotalAmountReceived()
});



// Function to clone and add fields
 function cloneAndAddFields() {
        var clonedFields = $("#addmore").clone(true, true); // Include event handlers when cloning
        clonedFields.find(".amount-receive").val(""); // Clear the values of the new input fields
        clonedFields.find(".date").val(""); // Clear the date values

        // Add a class to the cloned date input fields
        clonedFields.find(".date").addClass("cloned-date");

        // Bind the change event to the new date inputs
        clonedFields.find('.cloned-date').on('input', function () {
            updateTotalAmountReceived();
        });

        // Add a remove button for each set of cloned fields
        var removeButton = $('<button type="button" class="removeField">Remove</button>');
        clonedFields.append(removeButton);

        // Insert the cloned fields after the original fields
        $("#addmore").after(clonedFields);
    }

    // Handle the click event of the "Add More" button
    $("#addMoreAmount").click(function () {
        cloneAndAddFields();
    });

    // Handle the click event of the "Remove" button
    $(document).on('click', '.removeField', function () {
        $(this).parent().remove();
        updateTotalAmountReceived();
    });



function editQuotation() {
    var selectedClientUID = document.getElementById("name").value;
    var selectedQuotation = document.getElementById("address").value;
    var previousAmount = document.getElementById("total-amount").value;

    // Check if the form element exists before trying to access its properties
    var updateForm = document.getElementById("updateForm");
    if (updateForm) {
        // Toggle the visibility of the form
        if (updateForm.style.display === "block") {
            updateForm.style.display = "none";
        } else {
            updateForm.style.display = "block";
        }

        // Check if the form is visible, then hide the "EDIT" button
        var editButton = document.getElementById("editButton");
        if (editButton) {
            editButton.style.display = (updateForm.style.display === "block") ? "none" : "block";
        }
    } else {
        console.error("Element with id 'updateForm' not found.");
        return;
    }

    if (selectedClientUID && selectedQuotation) {
        // Set values in hidden input fields
        document.getElementById("cuid").value = selectedClientUID;
        document.getElementById("file-name").value = selectedQuotation;

        // Store the selected values in sessionStorage
        sessionStorage.setItem('selectedClientUID', selectedClientUID);
        sessionStorage.setItem('selectedQuotation', selectedQuotation);
        sessionStorage.setItem('previousAmount', previousAmount);

        // Uncomment the line below to redirect to the PHP script
        // window.location.href = 'c_damount_edit.php?client_uid=' + selectedClientUID + '&file_name=' + selectedQuotation;
    } else {
        // Handle the case where either the client UID or the quotation is not selected
        alert('Please select both Client UID and Quotation before editing.');
    }
}


$(document).ready(function () {
    // Handle the submit event of the update form
    $('#updateForm').submit(function (event) {
        // Prevent the default form submission behavior
        event.preventDefault();

        // Serialize the form data
        var formData = $(this).serialize();

        // Submit the form asynchronously using AJAX
        $.ajax({
            url: $(this).attr('action'),
            type: $(this).attr('method'),
            data: formData,
            success: function (response) {
              
                alert('Update form submitted successfully.');
                // Optionally, you can display a success message or perform other actions
            },
            error: function (xhr, status, error) {
                // Handle the error response here
                console.error('Error submitting update form:', error);
                // Optionally, you can display an error message or perform other actions
            }
        });
    });
});


function checkChequeStatus() {
    var clientId = document.getElementById("name").value;
    $.ajax({
        url: 'check_cheque_status.php',
        type: 'POST',
        data: { c_uid: clientId },
        success: function (response) {
            console.log("AJAX Response:", response);
            if (typeof response === 'object') {
                var chequeStatus = response.chequeStatus;
                if (chequeStatus === 2) {
                    $('#chequeOption').prop('disabled', true);
                } else {
                    $('#chequeOption').prop('disabled', false);
                }
            } else {
                console.error("Invalid JSON response:", response);
            }
        },
        error: function (xhr, status, error) {
            console.error("AJAX Error:", error);
        }
    });
}
// Function to hide the form
function hideForm() {
    var updateForm = document.getElementById("updateForm");
    if (updateForm) {
        updateForm.style.display = "none";
        var editButton = document.getElementById("editButton");
        if (editButton) {
            editButton.style.display = "block";
        }
    } else {
        console.error("Element with id 'updateForm' not found.");
    }
}
function calculateTotal() {
    // Add your calculation logic here
    // Example: Assuming product_price, d_amount, gst, packaging, and tcs are the IDs of your input fields
    var productPrice = parseFloat(document.getElementById("product_price").value) || 0;
    var discountAmount = parseFloat(document.getElementById("d_amount").value) || 0;
    var gst = parseFloat(document.getElementById("gst").value) || 0;
    var packaging = parseFloat(document.getElementById("packaging").value) || 0;
    var tcs = parseFloat(document.getElementById("tcs").value) || 0;

    var totalAmount = productPrice - discountAmount + gst + packaging + tcs;

    
    document.getElementById("total_amount_1").value = totalAmount.toFixed(2);
}
</script>
</html>
