<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

include_once("connection.php");
$dbConnection = new DbConnection();
$connection = $dbConnection->connection;

// Check if it's a GET request and 'uid' is set in the query parameters.
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['uid'])) {
    $c_uid = $_GET['uid'] ?? null;

    // Fetch data for the first row
    $query1 = "SELECT * FROM clients WHERE u_id = ?";
    $stmt1 = $connection->prepare($query1);
    $stmt1->bind_param("s", $c_uid);
    $stmt1->execute();
    $result1 = $stmt1->get_result();
    $row1 = $result1->fetch_assoc();

    // Check if $result1 is truthy (non-empty)
    if ($result1) {
        // Construct an associative array with the fetched data
        $data = array(
            'firmName' => $row1['firm_name'] ?? null,
            'courierAddress' => $row1['c_address'] ?? null,
            'shippingAddress' => $row1['s_address'] ?? null,
            'phoneNumber' => $row1['contact_number'] ?? null,
            'idGeneratedDate' => $row1['created_on'] ?? null,
        );

        // Send the data as JSON response
        header('Content-Type: application/json');
        echo json_encode($data);
        exit;
    } else {
        // Handle the case where $result1 is falsy (empty)
        // You may want to log an error or take appropriate action
        http_response_code(500); // Internal Server Error
        exit;
    }
} 


if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['quotation'])) {
    $Quotation_name = $_GET['quotation'] ?? null;

    // Fetch data for the second row
    $query2 = "SELECT * FROM qsend WHERE product_a = ?";  // Assuming c_uid is not needed for the query
    $stmt2 = $connection->prepare($query2);
    $stmt2->bind_param("s", $Quotation_name);  // Corrected the binding parameter
    $stmt2->execute();
    $result2 = $stmt2->get_result();
    $row2 = $result2->fetch_assoc();
    
    
    $query3 = "SELECT * FROM c_order WHERE q_do = ?";
    $stmt3 = $connection->prepare($query3);
    $stmt3->bind_param("s", $Quotation_name);
    $stmt3->execute();
    $result3 = $stmt3->get_result();
    $row3 = $result3->fetch_assoc();

    // Check if $result2 and $result3 are truthy (non-empty)
    if ($result2 && $result3) {
        // Construct an associative array with the fetched data
        $data = array(
            'quotationName' => $row2['product_a'] ?? null,
            'DeliveryDate' => $row2['created_on'] ?? null,
            'pending_amount' => $row3['pending_amount'] ?? null,
            'delivery_date' => $row3['d_month'] ?? null
        );

        // Send the data as JSON response
        header('Content-Type: application/json');
        echo json_encode($data);
        exit;
    } else {
        // Handle the case where $result2 or $result3 is falsy (empty)
        // You may want to log an error or take appropriate action
        http_response_code(500); // Internal Server Error
        exit;
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['machine_details'])) {
    $Machine = $_GET['machine_details'] ?? null;

    // Fetch data for the second row
    $query4 = "SELECT * FROM sales WHERE machine_uid= ?";  // Assuming c_uid is not needed for the query
    $stmt4 = $connection->prepare($query4);
    $stmt4->bind_param("s", $Machine);  // Corrected the binding parameter
    $stmt4->execute();
    $result4 = $stmt4->get_result();
    $row4 = $result4->fetch_assoc();
    
    
    $query5 = "SELECT * FROM uwarrante WHERE m_uid = ?";
    $stmt5 = $connection->prepare($query5);
    $stmt5->bind_param("s", $Machine);
    $stmt5->execute();
    $result5 = $stmt5->get_result();
    $row5 = $result5->fetch_assoc();
    
    $query6 = "SELECT * FROM paidrepair WHERE m_uid = ?";
    $stmt6 = $connection->prepare($query6);
    $stmt6->bind_param("s", $Machine);
    $stmt6->execute();
    $result6 = $stmt6->get_result();
    $row6 = $result6->fetch_assoc();

    // Check if $result2 and $result3 are truthy (non-empty)
    if ($result4 && $result5 && $result6) {
        // Construct an associative array with the fetched data
        $data = array(
            'machine_uid' => $row4['machine_uid'] ?? null,
            'pending-amount' => $row4['pending_amount'] ?? null,
            'PartsName' => $row5['parts_name'] ?? null,
            'HSN_code' => $row5['hsn_code'] ?? null,
            'reason'=> $row5['reason'] ?? NULL,
            'pPartsName' => $row6['parts_name'] ?? null,
            'pHSN_code' => $row6['hsn_code'] ?? null,
             'preason'=> $row6['reason'] ?? NULL
        );

        // Send the data as JSON response
        header('Content-Type: application/json');
        echo json_encode($data);
        exit;
    } else {
        // Handle the case where $result2 or $result3 is falsy (empty)
        // You may want to log an error or take appropriate action
        http_response_code(500); // Internal Server Error
        exit;
    }
}

?>
