<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

include_once('connection.php');

$dbConnection = new DBConnection();
$connection = $dbConnection->connection;

if ($connection) {
    // Check if the form is submitted
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        // Get form data  
        $u_id = isset($_POST['u_id']) ? $_POST['u_id'] : '';
       
        $file_name = isset($_POST['file_name']) ? $_POST['file_name'] : '';

        // Use prepared statement to prevent SQL injection
        $insert_query = $connection->prepare("INSERT INTO save_doffer (u_id, file_name) VALUES (?, ?)");
        $insert_query->bind_param("ss", $u_id, $file_name);

        // Check if the prepared statement was created successfully
        if ($insert_query) {
            // Execute the prepared statement
            if ($insert_query->execute()) {
                // Print a success message
                echo "Data saved successfully.";
            } else {
                // Print an error message
                echo "Error: " . $insert_query->error;
            }

            // Close the prepared statement
            $insert_query->close();
        } else {
            // Print an error message
            echo "Error: Unable to create a prepared statement.";
        }
    } else {
        // Print an error message if the form is not submitted
        echo "Error: Form not submitted.";
    }
} else {
    // Print an error message if unable to establish a database connection
    echo "Error: Unable to establish a database connection.";
}
?>
