<?php
session_start();
include('include/navigation.php');
include_once('connection.php');
require_once('class.php');
error_reporting(E_ALL);
ini_set('display_errors', 1);

$dbConnection = new DbConnection();
$connection = $dbConnection->connection;

$errors = [];
$successMessage = "";

if (isset($_SESSION["id"])) {
    header("Location: Q_dform.php");
    exit;
}

$offer = new Doffer();

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $file = $_FILES["file"];
    $remarks = $_POST["remarks"];

    $uploadDirectory = 'include/Detailed_offer_files';

    if (!file_exists($uploadDirectory)) {
        mkdir($uploadDirectory, 0777, true);
    }

    
    $tempFileName = $file["tmp_name"];

   
    $originalFileName = basename($file["name"]);

    $destinationPath = $uploadDirectory . '/' . $originalFileName;

    if (move_uploaded_file($tempFileName, $destinationPath)) {
        $record_id = $offer->DetailedOffer($originalFileName, $destinationPath, $remarks, $connection);

    
        if ($record_id) {
            $successMessage = "Record inserted successfully with ID: " . $record_id;
        } else {
            // Database insertion error
            $errors[] = "Error inserting record.";
        }
    } else {
        // File upload error
        $errors[] = "Error uploading file.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
     <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document</title>
    <link rel="stylesheet" href="include/css/client_form.css">
    <link rel="stylesheet" href="include/css/list.css">
     <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
</head>

<body>
      <div class="container"><br><br><br><br><br>
        <h2>Detailed Offer</h2>
        <button class="reset-button"><a href="Qview.php"><i class="fa-solid fa-backward"></i></a></button>

        <?php
        // Display errors, if any
        if (!empty($errors)) {
            echo '<div class="error-messages">';
            foreach ($errors as $error) {
                echo '<p>' . $error . '</p>';
            }
            echo '</div>';
        }

        // Display success message, if any
        if (!empty($successMessage)) {
            echo '<script>alert("' . $successMessage . '");</script>';
        }
        ?>

        <form action="" method="POST" enctype="multipart/form-data">
            <label for="file">File:</label>
            <input type="file" id="file" name="file" required>

            <label for="remarks">Remarks:</label>
            <input type="text1" id="remarks" name="remarks" required>

            <input type="submit" value="Submit">
        </form><br>
        
        <div id="table-container">
            <table>
                <thead>
                    <tr>
                        <th>S.no</th>
                        <th>File Name</th>
                        <th>Remarks</th>
                        <th>Download</th>
                        <th>Edit</th>
                        <th>Delete</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $display_query = "SELECT * FROM detailed_offer";
                    $results = mysqli_query($connection, $display_query);
                    $id = 1;
                    while ($data_row = mysqli_fetch_array($results, MYSQLI_ASSOC)) {
                    ?>
                        <tr>
                            <td><?php echo $id++ ?></td>
                            <td><?php echo $data_row['file_name']; ?></td>
                            <td><?php echo $data_row['remarks']; ?></td>
 
                           <td>
                                <a href="Q_dform_download.php?s_no=<?php echo $data_row['s_no']; ?>&file_name=<?php echo $data_row['file_name']; ?>" class="reset-button">
                                    <i class="fa fa-download"></i>
                                </a>
                            </td>

                            <td>
                                <button class="btn-primary" onclick="showEditBox(<?php echo $data_row['s_no']; ?>)">
                                    <a href="?id=<?php echo $data_row['s_no']; ?>"><img src="image\pencil-square.svg" class="image"></a>
                                </button>
                                <div id="edit-box-<?php echo $data_row['s_no']; ?>" class="edit-box" style="display: none;">
                                    <form method="POST" action="Q_dform_edit.php">
                                        <input type="hidden" name="s_no" value="<?php echo $data_row['s_no']; ?>">
                                        <input type="text" id="edit-remarks-<?php echo $data_row['s_no']; ?>" name="remarks" value="<?php echo htmlentities($data_row['remarks']);?>">
                                        <button type="submit" name="submit">Submit</button>
                                    </form>
                                </div>
                            </td>
                            <td>
                                <button class="btn-danger"><a href="Q_dform_delete.php?record=<?php echo htmlentities(json_encode($data_row)); ?>"><img src="image\trash3.svg" class="image"></a></button>
                            </td>
                        </tr>
                    <?php
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
<section class="footer">
    <?php include('include/footer_two.php') ?>
</section>
</body>
<script src="script/nav.js"></script>
<script>
 function showEditBox(s_no) {
        // Hide all existing input boxes
        var allInputBoxes = document.querySelectorAll('.edit-box');
        allInputBoxes.forEach(function (box) {
            box.style.display = 'none';
        });

        // Show the input box corresponding to the clicked button
        var editBox = document.getElementById('edit-box-' + s_no);
        if (editBox) {
            editBox.style.display = 'block';
        }
    }

    function submitEdit(s_no) {
        // Get the edited remarks from the input box
        var editedRemarks = document.getElementById('edit-remarks-' + s_no).value;

        // Perform any additional processing or validation as needed

        // You can send the edited remarks to the server using AJAX or perform any other action
        console.log('Edited Remarks:', editedRemarks);

        // Hide the edit box after submission
        var editBox = document.getElementById('edit-box-' + s_no);
        if (editBox) {
            editBox.style.display = 'none';
        }
    }
    
    </script>
</html>