<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

include_once('connection.php');
$dbConnection = new DbConnection();
$connection = $dbConnection->connection;

if (isset($_GET['record'])) {
    // Decode the JSON string from 'record' parameter
    $data_row = json_decode($_GET['record'], true);
    
    // Extract 's_no' from the decoded data
    $s_no = isset($data_row['s_no']) ? intval($data_row['s_no']) : 0;

    // Perform the delete operation in the database
    if ($s_no > 0) {
        $delete_query = "DELETE FROM detailed_offer WHERE s_no = ?";
        
        // Use prepared statement to prevent SQL injection
        $stmt = mysqli_prepare($connection, $delete_query);
        mysqli_stmt_bind_param($stmt, 'i', $s_no);
        mysqli_stmt_execute($stmt);
        
        // Check if the delete operation was successful
        if (mysqli_affected_rows($connection) > 0) {
             $user_id = $_SESSION["user"]['id'];
                $name = $_SESSION["user"]["name"]; // Firm name as per your form
                $email = $_SESSION["user"]["email"];
                $roles = $_SESSION["user"]["roles"]; // Assuming all registered users are clients
                $action = "Delete";
                $tabel = "detailed_offer";
                $created_on = date("Y-m-d H:i:s"); // Current date and time
        
        // Query to insert user log into database
               $insert_user_log_query = "INSERT INTO users_log (user_id, name, email, roles, action,tabel, created_on) VALUES (?, ?, ?, ?, ?, ?,?)";
                $stmt = $connection->prepare($insert_user_log_query);
                $stmt->bind_param("issssss", $user_id, $name, $email, $roles, $action, $tabel,$created_on);
                $stmt->execute();
                 
           echo '<script>alert("Record deleted successfully."); window.location.href = "Q_dform.php";</script>';

        } else {
            echo "Error deleting record: " . mysqli_error($connection);
        }

        // Close the statement
        mysqli_stmt_close($stmt);
    } else {
        echo "Invalid 's_no' value.";
    }
}


?>
