<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

include_once('connection.php');

$dbConnection = new DbConnection();
$connection = $dbConnection->connection;

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['submit'])) {
    // Get the submitted remarks and sanitize it (to prevent SQL injection)
    $editedRemarks = mysqli_real_escape_string($connection, $_POST['remarks']);
    $s_no = mysqli_real_escape_string($connection, $_POST['s_no']);

    // Check if the ID exists in the database before updating
    $check_query = "SELECT s_no FROM detailed_offer WHERE s_no = $s_no";
    $check_result = mysqli_query($connection, $check_query);

    if (mysqli_num_rows($check_result) > 0) {
        // Use prepared statements to prevent SQL injection
        $update_query = "UPDATE detailed_offer SET remarks = ? WHERE s_no = ?";
        $stmt = mysqli_prepare($connection, $update_query);

        mysqli_stmt_bind_param($stmt, "si", $editedRemarks, $s_no);

        $update_result = mysqli_stmt_execute($stmt);

        // Check if the update was successful
        if ($update_result) {
            echo '<script>';
            echo 'alert("Remarks updated successfully!");';
            echo 'window.location.href = "Q_dform.php"'; // Replace with your actual redirection page
            echo '</script>';
        } else {
            echo "Error updating remarks: " . mysqli_error($connection);
        }
    } else {
        echo "Invalid ID.";
    }
}
?>
