<?php
session_start();
use PHPMailer\PHPMailer\PHPMailer; 
use PHPMailer\PHPMailer\SMTP; 
use PHPMailer\PHPMailer\Exception; 

require_once('tcpdf/tcpdf.php');
include_once('connection.php');
$dbConnection = new DbConnection();
$connection = $dbConnection->connection;
class MYPDF extends TCPDF {
    public function Header() {
        $path = dirname(__FILE__);
        $logo = $path . '/image/header.png';

        // Logo in header
        $this->Image($logo, 20, 10, 150, '', 'PNG', '', 'T', false, 300, '', false, false, 0, false, false, false);

        // Header text
        $formattedDate = '';
        if (isset($_GET['created_on'])) {
            $createdOn = $_GET['created_on'];
            $formattedDate = date('Y-m-d', strtotime($createdOn));
        }

        $this->SetFont('helvetica', 'B', 12);
        $this->SetXY(20, 20);
        $this->Cell(0, 30, 'Product Information By Lehra ' . $formattedDate, 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }

    public function Footer() {
        $path = dirname(__FILE__);
        $logo = $path . '/image/footer.png';

        // Footer text
        $this->SetY(-15);
        $this->SetFont('helvetica', 'I', 10);
        $pageWidth = $this->getPageWidth();
        $imageWidth = 150;  // Adjust the width as needed
        $centerX = ($pageWidth - $imageWidth) / 2;

    // Logo in footer, centered horizontally
    $this->Image($logo, $centerX, $this->getY(), $imageWidth, 15, 'PNG', '', 'T', false, 300, '', false, false, 0, false, false, false);

        //  $pageWidth = $this->getPageWidth();
        // $this->Image($logo, $this->getMargins()['left'], $this->getY(), $pageWidth, 10, 'PNG', '', 'T', false, 300, '', false, false, 0, false, false, false);

        
        
    }
}

function generatePDFContent($clientUID, $data_array) {
     $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

    // Add a header with a logo
    $pdf->Header();

    // Add a footer with a different logo
    $pdf->Footer();

    // Add content to the PDF
    $pdf->AddPage();
    $pdf->SetY($pdf->GetY() + 30); // Adjust the value as needed

    // Set font size for the content
    $pdf->SetFont('helvetica', '', 14); // You can adjust the font size as needed

    $pdf->Cell(0, 20, 'Client UID: ' . $clientUID, 0, 1); // Align to the left
    // Loop through the data_array and display the data
    foreach ($data_array as $data) {
        $pdf->Cell(0, 10, 'Product Name: ' . $data['p_name'], 0, 1, 'C');
        $pdf->Cell(0, 10, 'Brand: ' . $data['brand'], 0, 1, 'C');
        $pdf->Cell(0, 10, 'About: ' . $data['about'], 0, 1, 'C');
        $pdf->Cell(0, 10, 'Description: ' . $data['description'], 0, 1, 'C');
        $pdf->Cell(0, 10, 'Brand: ' . $data['quantity'], 0, 1, 'C');
        $pdf->Cell(0, 10, 'Brand: ' . $data['budget'], 0, 1, 'C');
        $pdf->Cell(0, 10, 'Discount Amount: ' . $data['d_amount'], 0, 1, 'C');
         $pdf->Cell(0, 10, 'GST: ' . $data['gst'], 0, 1, 'C');
        $pdf->Cell(0, 10, 'Packaging Charge: ' . $data['packaging'], 0, 1, 'C');
        if ($data['tcs'] !== null && $data['tcs'] !== '') {
            $pdf->Cell(0, 10, 'TCS: ' . $data['tcs'], 0, 1, 'C');
        }
        $pdf->Cell(0, 10, 'Total Amount: ' . $data['total_amount'], 0, 1, 'C');

        // Add a separator line after each data set
        // $pdf->Cell(0, 0, 1);
    }

    return $pdf;


    }


// Get the product_a and c_uid from the URL parameters
if (isset($_GET['product_a']) && isset($_GET['c_uid'])) {
    $product_a = $_GET['product_a'];
    $clientUID = $_GET['c_uid'];

    
$query = "SELECT p_name, brand, about, description, quantity, budget, d_amount FROM qdata where file_name='$product_a'";
    $result = mysqli_query($connection, $query);
    $data_array = array();
     while ($row = mysqli_fetch_assoc($result)) {
    $data_array[] = $row;
}

    require 'vendor/phpmailer/phpmailer/src/Exception.php';
    require 'vendor/phpmailer/phpmailer/src/PHPMailer.php';
    require 'vendor/phpmailer/phpmailer/src/SMTP.php';
       
   require 'vendor/autoload.php';

// var_dump($data_array);
 if ($_GET['ACTION'] == 'EMAIL') {
    // Generate the PDF content
    $pdf = generatePDFContent($clientUID, $data_array);
    $pdfContent = $pdf->Output('', 'S');              
        $file_prefix = "revised";
        $current_date = date('y-m-d'); // Format: YY-MM-DD
        
        $file_name = "$file_prefix" . "_$product_a" . "_$current_date";
    
    // Initialize PHPMailer
    $mail = new PHPMailer(true);
    $mail->CharSet = 'UTF-8';

    try {
        $mail->isSMTP();
        $mail->Host = 'mail.lehrafuel.net'; // Replace with your SMTP server address
        $mail->SMTPAuth = true;
        $mail->Username = 'noreply@lehrafuel.net'; // SMTP username
        $mail->Password = 'Ep64kgJ3)Lpf'; // SMTP password
        $mail->SMTPSecure = 'ssl'; // Enable implicit TLS encryption (ssl) or 'tls'
        $mail->Port = 465; // TCP port to connect to

        $mail->setFrom('noreply@lehrafuel.net', 'Lehra'); 
        $mail->isHTML(true);

        $mail->Subject = 'Quotation Details';  // Set the subject of the email
        $mail->Body = 'Dear, Sir/mam. Please find Attachment Below ';  // Set the email body content
            
        // Fetch the client's email address from the database
        $query = "SELECT email FROM clients WHERE u_id = $clientUID";
        $result = mysqli_query($connection, $query);


        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $email = $row["email"];
                $mail->addAddress($email);
                $mail->addStringAttachment($pdfContent, $file_name);

                // Send the email
                if ($mail->send()) {
                    echo "<script>alert('Message sent to $email!'); window.location.href = 'Qlist.php';</script>";
                } else {
                    echo "<script>alert('Error sending email.'); window.location.href = 'Qlist.php';</script>";
                   
                    echo "Mailer Error: " . $mail->ErrorInfo;
                }
            }
        } else {
            echo "<script>alert('Record not found for PDF.');window.location.href = 'Qlist.php';</script>";
        }
    } catch (Exception $e) {
        echo "Error: " . $e->getMessage();
    }
} else {
    echo 'Invalid action.';
}
}
?>

