<?php
session_start();
use PHPMailer\PHPMailer\PHPMailer; 
use PHPMailer\PHPMailer\SMTP; 
use PHPMailer\PHPMailer\Exception; 

require_once('tcpdf/tcpdf.php');
include_once('connection.php');
$dbConnection = new DbConnection();
$connection = $dbConnection->connection;

class MYPDF extends TCPDF {
    public function Header() {
        $path = dirname(__FILE__);
        $logo = $path . '/image/header.png';

        // Logo in header
         $this->Image($logo, 20, 10, 150, '', 'PNG', '', 'T', false, 300, '', false, false, 0, false, false, false);
        // Header text
        $createdOn = $_GET['created_on'];
        $file=$_get['product_a'];
        $formattedDate = date('Y-m-d', strtotime($createdOn));
        $this->SetFont('helvetica', 'B', 12);
        $this->SetXY(20, 20);
        $this->Cell(0, 30, 'Product Information By Lehra' . $formattedDate, 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }

    public function Footer() {
        $path = dirname(__FILE__);
        $logo = $path . '/image/footer.png';

        // Footer text
        $this->SetY(-15);
        $this->SetFont('helvetica', 'I', 10);
        $pageWidth = $this->getPageWidth();
        $imageWidth = 150;  // Adjust the width as needed
        $centerX = ($pageWidth - $imageWidth) / 2;

    // Logo in footer, centered horizontally
    $this->Image($logo, $centerX, $this->getY(), $imageWidth, 15, 'PNG', '', 'T', false, 300, '', false, false, 0, false, false, false);

        //  $pageWidth = $this->getPageWidth();
        // $this->Image($logo, $this->getMargins()['left'], $this->getY(), $pageWidth, 10, 'PNG', '', 'T', false, 300, '', false, false, 0, false, false, false);

        
        
    }
}

// function to Generate PDF
function generatePDFContent($clientUID, $data_array) {
    // Create a new TCPDF instance with default page size 'A4'
     $pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

    // Set margins
    $pdf->SetMargins(20, 20, 20);

    // Add content to the PDF
    $pdf->AddPage();
    $pdf->SetY($pdf->GetY() + 30); // Adjust the value as needed

    // Set font size for the content
    $pdf->SetFont('helvetica', '', 14); // You can adjust the font size as needed

    // Add client UID
     $pdf->SetFont('helvetica', 'B', 12);
    $pdf->Cell(0, 20, 'Client UID: ' . $clientUID, 0, 1, 'C'); // Align to the center
    
    // Create table header
    $pdf->SetFont('helvetica', 'B', 12);
    $pdf->Cell(0, 10, 'Product Information', 1, 1, 'C'); // End line after this cell

    // Calculate available width for content
    $availableWidth = $pdf->GetPageWidth() - $pdf->getMargins()['left'] - $pdf->getMargins()['right'];

    // Loop through the data_array and display the data in a table format
    foreach ($data_array as $data) {
        foreach ($data as $key => $value) {
            // Calculate width for each column
            $cellWidth = $availableWidth / 2; // Divide by 2 for two columns

            // Output data with adjusted cell width
            $pdf->Cell($cellWidth, 10, $key, 1, 0, 'L'); // Column 1: Field
            $pdf->Cell($cellWidth, 10, $value, 1, 1, 'L'); // Column 2: Value, end line after this cell
        }
    }

    return $pdf;
}

// Get the product_a and c_uid from the URL parameters
if (isset($_GET['product_a']) && isset($_GET['c_uid'])) {
    $product_a = $_GET['product_a'];
    $clientUID = $_GET['c_uid'];
// echo $product_a;    // Retrieve the specific data row based on the selected c_uid and product_a
    
$query = "SELECT p_name, brand, about, description, quantity, budget, d_amount,gst,packaging,tcs,total_amount FROM qdata where file_name='$product_a'";
    $result = mysqli_query($connection, $query);
    $data_array = array();
     while ($row = mysqli_fetch_assoc($result)) {
    $data_array[] = $row;
}

    require 'vendor/phpmailer/phpmailer/src/Exception.php';
    require 'vendor/phpmailer/phpmailer/src/PHPMailer.php';
    require 'vendor/phpmailer/phpmailer/src/SMTP.php';
       
   require 'vendor/autoload.php';

// var_dump($data_array);
    if ($_GET['ACTION'] == 'VIEW') {
        // Generate the PDF and output it to the browser for inline view
        $pdf = generatePDFContent($clientUID, $data_array);
        $pdf->Output('product_info.pdf', 'I');
    } elseif ($_GET['ACTION'] == 'DOWNLOAD') {
        // Generate the PDF and prompt the user to download it
        $pdf = generatePDFContent($clientUID, $data_array);
        $pdf->Output('product_info.pdf', 'D');
    }
    
elseif ($_GET['ACTION'] == 'EMAIL') {
    $pdf = generatePDFContent($clientUID, $data_array);
    $pdfContent = $pdf->Output('', 'S');

    $file_name = "$product_a";

    // Initialize PHPMailer
    $mail = new PHPMailer(true); 
    $mail->CharSet = 'UTF-8';

    try {
        $mail->isSMTP();
        $mail->Host = 'mail.lehrafuel.net'; // Replace with your SMTP server address
        $mail->SMTPAuth = true;
        $mail->Username = 'noreply@lehrafuel.net'; // SMTP username
        $mail->Password = 'Ep64kgJ3)Lpf'; // SMTP password
        $mail->SMTPSecure = 'ssl'; // Enable implicit TLS encryption (ssl) or 'tls'
        $mail->Port = 465; // TCP port to connect to

        $mail->setFrom('noreply@lehrafuel.net', 'Lehra');
        $mail->isHTML(true);

        $mail->Subject = 'Quotation Details';  // Set the subject of the email
        $mail->Body = 'Dear, Sir/mam. Please find Attachment Below ';  // Set the email body content
            
        // Fetch the client's email address from the database
        $query = "SELECT email FROM clients WHERE u_id = $clientUID";
        $result = mysqli_query($connection, $query);

        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $email = $row["email"];
                $mail->addAddress($email);
                $mail->addStringAttachment($pdfContent, $file_name);

                // Send the email
             if ($mail->send()) {
                echo "<script>alert('Message sent to $email!'); window.location.href = 'Qlist.php';</script>";
            } else {
                echo "<script>alert('Error sending email.'); window.location.href = 'Qlist.php';</script>";
                // Log the error to a file
                error_log("Email Error: " . $mail->ErrorInfo, 3, "/path/to/error.log");
            }
            }
        } else {
            echo "<script>alert('Record not found for PDF.');window.location.href = 'Q_share.php';</script>";
        }
    } catch (Exception $e) {
        echo "Error: " . $e->getMessage();
    }
} else {
    echo 'Invalid action.';
}
}
?>

