<?php
session_start();
include('include/navigation.php');
include_once('connection.php');
require_once('class.php');
$dbConnection = new DbConnection();
$connection = $dbConnection->connection;
error_reporting(E_ALL);
ini_set('display_errors', 1);
// Check if the user is already logged in, redirect to Qview.php if true
if (isset($_SESSION["id"])) {
    header("Location: Qview.php");
    exit;
}

// Function to generate a file name based on the current year
function generateFileName() {
    define("CURRENT_YEAR", date("Y")); // Define a constant for the current year
    $fileName = "Lehra_" . CURRENT_YEAR . "_";
    return $fileName;
}
$fileName = generateFileName(); 
// Create an instance of the Qutation class
$Qutation = new Qutation();

// Check if the form is submitted
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    // Escape and retrieve form data
    $p_name = isset($_POST["p_name"]) ? mysqli_real_escape_string($Qutation->connection, $_POST["p_name"]) : '';
    $brand = isset($_POST["brand"]) ? mysqli_real_escape_string($Qutation->connection, $_POST["brand"]) : '';
    $about = isset($_POST["about"]) ? mysqli_real_escape_string($Qutation->connection, $_POST["about"]) : '';
    $description = isset($_POST["description"]) ? mysqli_real_escape_string($Qutation->connection, $_POST["description"]) : '';
    $quantity = isset($_POST["quantity"]) ? mysqli_real_escape_string($Qutation->connection, $_POST["quantity"]) : '';
    $budget = "Rs " . (isset($_POST["budget"]) ? mysqli_real_escape_string($Qutation->connection, $_POST["budget"]) : '');
    $d_amount = "Rs " . (isset($_POST["d_amount"]) ? mysqli_real_escape_string($Qutation->connection, $_POST["d_amount"]) : '');
    $packaging = (isset($_POST["packaging"]) ? mysqli_real_escape_string($Qutation->connection, $_POST["packaging"]) : '')."%";;
    $gst = (isset($_POST["gst"]) ? mysqli_real_escape_string($Qutation->connection, $_POST["gst"]) : '')."%";;
    $tcs = (isset($_POST["tcs"]) ? mysqli_real_escape_string($Qutation->connection, $_POST["tcs"]) : '')."%";;
    $total_amount = isset($_POST["total_amount"]) ? mysqli_real_escape_string($Qutation->connection, $_POST["total_amount"]) : '';
    $file_name = "$fileName" . (isset($_POST["additional_text"]) ? $_POST["additional_text"] : '');

    // Call the Qform method with the form data
    $result = $Qutation->Qform($p_name, $brand, $about, $description, $quantity, $budget, $d_amount, $packaging, $gst,  $tcs, $total_amount, $file_name);

    // Check the result and display an alert
    if ($result == 1) {
                 $user_id = $_SESSION["user"]['id'];
                $name = $_SESSION["user"]["name"]; // Firm name as per your form
                $email = $_SESSION["user"]["email"];
                $roles = $_SESSION["user"]["roles"]; // Assuming all registered users are clients
                $action = "Insert";
                $tabel = "qdata";
                $created_on = date("Y-m-d H:i:s"); // Current date and time
        
        // Query to insert user log into database
               $insert_user_log_query = "INSERT INTO users_log (user_id, name, email, roles, action,tabel, created_on) VALUES (?, ?, ?, ?, ?, ?,?)";
                $stmt = $connection->prepare($insert_user_log_query);
                $stmt->bind_param("issssss", $user_id, $name, $email, $roles, $action, $tabel,$created_on);
                $stmt->execute();
                 $stmt->close();
        echo "<script> alert(' Added Successful'); </script>";
    } elseif ($result == 10) {
        echo "<script> alert('Something went Wrong'); </script>";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<?php include('include/form_header_link.php');  ?>
<link rel="stylesheet" href="include/css/client_form.css">
</head> 
 <body>
     <div class="container">   
        <h2>Add New Product</h2>
        <button class="reset-button"><a href="Qview.php"><i class="fa-solid fa-backward"></i></a></button>
        <form action="" method="POST">
            <label for="p_name">Product Name:</label>
            <input type="text1" id="" name="p_name" placeholder="Enter product name" required>

            <label for="brand">Category:</label>
            <input type="text1" id="" name="brand" placeholder="Enter your category" required>

            <label for="about">About Product:</label>
            <input type="text1" id="" name="about" placeholder="About product" required>

            <label for="description">Description:</label>
            <textarea id="" name="description" placeholder="detailed description" required></textarea>

            <label for="quantity">Quantity:</label>
            <input type="number" id="contact_number" name="quantity" placeholder="Quantity" min="0" required>

            <label for="product_price">Product Price:</label>
             <input type="text1" value="Rs. " style="width:5%" readonly>
            <input type="text1" id="product_price" placeholder="Product Price" name="budget" style="width:94%"oninput="calculateTotal()" required>
            
            <label for="d_amount">Discount Amount:</label>
             <input type="text1" value="Rs. " style="width:5%" readonly>
            <input type="text1" id="d_amount" placeholder="Discount amount" name="d_amount" style="width:94%" oninput="calculateTotal()" required>
            
            <label for="packaging">Packaging charge (In Percentage):</label>
            <input type="text1" id="packaging" placeholder="Packaging charge" name="packaging"value="4" oninput="calculateTotal()" style="width:94%" required>
            <input type="text1" value="%" style="width:5%" readonly>
            
            <label for="gst">GST charge (In Percentage):</label>
            <input type="text1" id="gst" placeholder="GST" value="18" name="gst"oninput="calculateTotal()" style="width:94%" required>
            <input type="text1" value="%" style="width:5%" readonly>
            
            <label for="tcs">T.C.S (In Percentage):</label>
            <input type="text1" id="tcs" placeholder="TCS" value="0.01" name="tcs"oninput="calculateTotal()" style="width:94%">
            <input type="text1" value="%" style="width:5%" readonly>
            
            <label for="total_amount">Total Amount:</label>
            <input type="text1" id="budget" placeholder="Total Amount" name="total_amount" readonly>


     <label for="file_name">File Name:</label>
     <div class="custom-input">
   <input type="text1" id="custom_file_name" name="file_name" value="<?php echo $fileName; ?>" readonly>
    <input type="text1" id="additional_text" name="additional_text" placeholder="Add filename...">
</div>      
            <input type="submit" value="Submit">
        </form>
    </div>
    <section class="footer">
    <?php include('include/footer_two.php');            ?>
</section>
</body>
<script src="script/nav.js"></script>
<script>
  // Set default values for packaging, GST, and TCS
    var defaultPackaging = "4";
    var defaultGST = "18";
    var defaultTCS = "0.01";

    // Initialize values and calculate total
    document.getElementById("product_price").value;
    document.getElementById("d_amount").value ;
    document.getElementById("packaging").value = defaultPackaging;
    document.getElementById("gst").value = defaultGST;
    document.getElementById("tcs").value = defaultTCS;
    calculateTotal();

    // Add event listeners to allow users to edit default values
    document.getElementById("packaging").addEventListener("input", function () {
      calculateTotal();
    });

    document.getElementById("gst").addEventListener("input", function () {
      calculateTotal();
    });

    document.getElementById("tcs").addEventListener("input", function () {
      calculateTotal();
    });

    function calculateTotal() {
      // Get values from input fields
      var productPrice = parseAmount(document.getElementById("product_price").value);
      var discountAmount = parseAmount(document.getElementById("d_amount").value);
      var packagingCharge = parseAmount(document.getElementById("packaging").value);
      var gst = parseAmount(document.getElementById("gst").value);
      var tcs = parseAmount(document.getElementById("tcs").value);

      // Calculate total amount
      const discountedPrice = productPrice - discountAmount;
      const totalWithPackaging = discountedPrice + (discountedPrice * packagingCharge / 100);
      const totalWithGST = totalWithPackaging + (totalWithPackaging * gst / 100);
      const finalTotal = totalWithGST + (totalWithGST * tcs / 100);

      // Display the total amount 
      document.getElementById("budget").value = "Rs " + finalTotal.toFixed(2);
    }

    function parseAmount(value) {
      // Extract numeric part and parse as float
      var numericValue = parseFloat(value.replace(/[^\d.]/g, ''));

      // Check if the numeric value is NaN, set it to 0
      return isNaN(numericValue) ? 0 : numericValue;
    }
document.addEventListener("DOMContentLoaded", function() {
    const customFileName = document.getElementById("custom_file_name");
    const additionalText = document.getElementById("additional_text");

    additionalText.addEventListener("input", function() {
        customFileName.value = "<?php echo $fileName  ?>" + this.value;
    });
});</script>
</html>


