<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
include('include/navigation.php');
include_once("connection.php");
$dbConnection = new DbConnection();
$connection = $dbConnection->connection;

function getColor($date) {
    $currentDate = new DateTime();
    
    if ($date !== null) {
        $inputDate = DateTime::createFromFormat('Y-m-d', $date);

        if ($inputDate !== false) {
            $difference = $currentDate->diff($inputDate)->days;

            if ($difference <= 90) {
                return "green";
            }
        }
    }

    return "light"; 
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sales List</title>
    <link rel="stylesheet" href="include/css/list.css">
    <style>
        .disabled-undo {
            background-color: #b5e7a0;
        }
    </style>
</head>
<script>
function confirmToUndo(c_uid, q_do, total_amount, final_amount, amount_receive, payment_mode, date, bank_name, total_amount_receive, pending_amount, d_month) {
        var confirmationMessage = "Are you sure you want to undo this sale?\n\n" +
            "Client UID: " + c_uid + "\n" +
            "Product Name: " + q_do + "\n" +
            "Delivery Month: " + d_month + "\n" +
            "Total Amount: " + total_amount + "\n" +
            "Final Amount: " + final_amount + "\n" +
            "Amount Receive : " + amount_receive + "\n" +
            "Payment Mode: " + payment_mode + "\n" +
            "Date: " + date + "\n" +
            "Bank name: " + bank_name + "\n" +
            "Total Amount Receive : " + total_amount_receive + "\n" +
            "Pending Amount: " + pending_amount + "\n";

        var confirmation = confirm(confirmationMessage);
        if (confirmation) {
            var saleUrl = `sales_undo.php?c_uid=${c_uid}&q_do=${q_do}&total_amount=${total_amount}&final_amount=${final_amount}&amount_receive=${amount_receive}&payment_mode=${payment_mode}&date=${date}&bank_name=${bank_name}&total_amount_receive=${total_amount_receive}&pending_amount=${pending_amount}&d_month=${d_month}`;
            window.location.href = saleUrl;
        }
        return false;
    }
</script>
<body>
    <div class="container"><br><br><br><br>
        <div class="flexbox">
            <center><h2>Sales List</h2></center>
        </div><br>
        
        <div>
            <table>
                <thead>
                    <tr>
                        <th>S.no</th>
                        <th>Client UID</th>
                        <th>Product Name</th>
                        <th>Delivery Month</th>
                        <th>Machine S.No</th>
                        <th>undo</th>
                        <th>File Upload</th>
                        <th>Status</th>
                        <th>1st Warranty Ends </th>
                        <th>Warantee Till</th>
                        <th>Warantee Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    // $query = "SELECT s.*, w.end_date FROM sales s LEFT JOIN warranty_start w ON s.c_uid = w.client_uid";
    $query = "SELECT s.*, MAX(w.end_date) AS max_end_date
          FROM sales s
          LEFT JOIN warranty_start w ON s.c_uid = w.client_uid AND s.q_do = w.product_name
          GROUP BY s.id, s.c_uid, s.q_do, s.d_month, s.machine_uid, s.updated_on
          ORDER BY s.updated_on DESC";

                    $result = mysqli_query($connection, $query);
                    $id = 1;

                    if ($result && mysqli_num_rows($result) > 0) {
                        while ($row = mysqli_fetch_assoc($result)) {
                            // Check if warranty button color is green
                            $warrantyColor = getColor($row['updated_on']);
                            $isWarrantyGreen = ($warrantyColor == 'green');

                            echo "<tr>";

                            // Output sales data
                            echo "<td>{$id}</td>";
                            echo "<td>{$row['c_uid']}</td>";
                            echo "<td>{$row['q_do']}</td>";
                            echo "<td>{$row['d_month']}</td>";
                            echo "<td>{$row['machine_uid']}</td>";

                            // Undo button
                            echo '<td>
                                <button class="btn-primary';

                            // Add class to the undo button for styling
                            if ($isWarrantyGreen) {
                                echo ' disabled-undo';
                            }

                          echo '" onclick="confirmToUndo(\'' 
                                    . htmlspecialchars($row['c_uid']) . '\', \'' . htmlspecialchars($row['q_do']) . '\', \''
                                     . htmlspecialchars($row['total_amount']) . '\', \''
                                    . htmlspecialchars($row['final_amount']) . '\', \''
                                    . htmlspecialchars(serialize($row['amount_receive'])) . '\', \''
                                    . htmlspecialchars(serialize($row['payment_mode'])) . '\', \''
                                    . htmlspecialchars(serialize($row['date'])) . '\', \''
                                    . htmlspecialchars(serialize($row['bank_name'])) . '\', \''
                                    . htmlspecialchars($row['total_amount_receive']) . '\', \'' 
                                    . htmlspecialchars($row['pending_amount']) . '\', \''
                                    . htmlspecialchars($row['d_month']) . '\')"';
                            // Disable undo button if warranty button color is green
                            if ($isWarrantyGreen) { 
                                echo ' disabled';
                            }

                            echo '>
                                <img src="image/arrow-repeat.svg" alt="Restore" class="image">
                            </button>
                            </td>';


                            // File upload section
                            echo '<td> 
                                <form action="sales_file_upload.php" method="post" enctype="multipart/form-data"';

                            // Disable form if warranty button color is green
                            if ($isWarrantyGreen) {
                                echo ' disabled';
                            }

                            echo '>
                                <input type="hidden" name="id" value="' . $row['id'] . '">
                                <input type="hidden" name="c_uid" value="' . $row['c_uid'] . '">
                                <input type="hidden" name="machine_uid" value="' . $row['machine_uid'] . '">
                                <input type="hidden" name="q_do" value="'. $row['q_do'] . '">
                                <input type="file" name="file_name" required';

                            // Disable file input if warranty button color is green
                            if ($isWarrantyGreen) {
                                echo ' disabled';
                            }

                            echo '>
                                <input type="date" name="updated_on" required';

                            // Disable date input if warranty button color is green
                            if ($isWarrantyGreen) {
                                echo ' disabled';
                            }

                            echo '>
                                <button class="wrantee" type="submit"';

                            // Disable submit button if warranty button color is green
                            if ($isWarrantyGreen) {
                                echo ' disabled';
                            }

                            echo '>Submit</button>
                            </form>
                            </td>';

                            // Warranty button
                            echo '<td>
                              <button id="button_' . $row['id'] . $row['q_do'] . '" class="bg-color" style="background-color: ' . $warrantyColor . '; width:80px;"';

                            // Enable warranty button (remove the disabled attribute)
                            if ($isWarrantyGreen) {
                                echo '';
                            } else {
                                echo ' disabled';
                            }

                            echo ' >Warranty</button> 
                            </td>';
                            
                            
                            
                           
                            
                            $originalDate = $row['updated_on'];
                            
                            // Check if the original date is not null or empty
                            if (!empty($originalDate)) {
                                // Convert the original date to a DateTime object
                                $dateTime = new DateTime($originalDate);
                            
                                // Add 90 days to the original date
                                $dateTime->add(new DateInterval('P90D'));
                            
                                // Format the new date as desired
                                $newDate = $dateTime->format('Y-m-d');
                            
                                // Display the new date in your table cell
                                echo "<td>{$newDate}</td>";
                            } else {
                                // Handle the case when the original date is null or empty
                                echo "<td>No date available</td>";
                            }
                            
                            
                            
                            echo "<td>{$row['max_end_date']}</td>";
                            
                            // Renew button
                           echo '<td><a href="warantee_action.php?c_uid=' . $row['c_uid'] . '&q_do=' . $row['q_do'] . '&updated_on=' . $row['updated_on'] . '&machine_uid=' . $row['machine_uid'] . '" class="reset-button">Renew</a></td>';
                           echo "</tr>";
                            $id++;
                        }
                    } else {
                        echo "<tr><td colspan='8'>No sales data found.</td></tr>";
                    }
                    mysqli_free_result($result);
                    ?>
                </tbody>
            </table>
        </div>
    </div><br><br>
  
<section class="footer">
    <?php include('include/footer_two.php') ?>
</section>
</body>
<script src="script/nav.js"></script>
</html>
