<?php
include_once('connection.php');
include_once('class.php');


$dbConnection = new DbConnection();
$connection = $dbConnection->connection;
error_reporting(E_ALL);
ini_set('display_errors', 1);
$selectedQuotation = isset($_POST['quotation']) ? $_POST['quotation'] : '';

// Use prepared statements to prevent SQL injection
$query = "SELECT total_amount, budget, d_amount, gst, packaging, tcs FROM `qdata` WHERE file_name = ?";
$stmt = mysqli_prepare($connection, $query);

// Bind the parameter
mysqli_stmt_bind_param($stmt, "s", $selectedQuotation);

// Execute the statement
mysqli_stmt_execute($stmt); 

// Bind the result
mysqli_stmt_bind_result($stmt, $totalAmount, $product_price, $discount_amount, $gst_charge, $packaging_charge, $tcs);

// Fetch the result
if (mysqli_stmt_fetch($stmt)) {
    
    $response = array(
        'total_amount' => $totalAmount,
        'budget' => $product_price,
        'd_amount' => $discount_amount,
        'gst' => $gst_charge,
        'packaging' => $packaging_charge,
        'tcs' => $tcs
    );

    // Return the response as JSON
    echo json_encode($response);
} else {
    echo json_encode(array('error' => 'Error in query execution'));
}

// Close the statement and database connection
mysqli_stmt_close($stmt);
mysqli_close($connection);
?>
