<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

include_once('connection.php');

$dbConnection = new DbConnection();
$connection = $dbConnection->connection;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST["update"])) {
    $client_uid = $_POST['client_uid'];
    $file_name = $_POST['file_name'];
    $product_price = $_POST['product_price'];
    $d_amount = $_POST['d_amount'];
    $gst = $_POST['gst'];
    $packaging = $_POST['packaging'];
    $tcs = $_POST['tcs'];
    $total_amount = $_POST['total_amount'];

    // Sanitize inputs to prevent SQL injection
    $product_price_n = floatval($product_price);
    $d_amount_n = floatval($d_amount);
    $gst_n = floatval($gst);
    $packaging_n = floatval($packaging);
    $tcs_n = floatval($tcs);
    $total_amount_n = floatval($total_amount);

    // Use an INSERT query
    $query = "INSERT INTO updated_amount (client_uid, file_name, product_price, d_amount, gst, packaging, tcs, total_amount) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    
    $stmt = mysqli_prepare($connection, $query);
    mysqli_stmt_bind_param($stmt, "issddddd", $client_uid, $file_name, $product_price_n, $d_amount_n, $gst_n, $packaging_n, $tcs_n, $total_amount_n);

    $result_update = mysqli_stmt_execute($stmt);

    mysqli_stmt_close($stmt);

    if ($result_update) {
      
    $user_id = $_SESSION["user"]['id'];
    $name = $_SESSION["user"]["name"];
    $email = $_SESSION["user"]["email"];
    $roles = $_SESSION["user"]["roles"];
    $action = "Insert";
    $table = "updated_amount";
    $created_on = date("Y-m-d H:i:s");

    // Query to insert user log into database
    $insert_user_log_query = "INSERT INTO users_log (user_id, name, email, roles, action, tabel, created_on) VALUES (?, ?, ?, ?, ?, ?, ?)";
    $stmt = $connection->prepare($insert_user_log_query);
    $stmt->bind_param("issssss", $user_id, $name, $email, $roles, $action, $table, $created_on);
    $stmt->execute();
    $stmt->close();
        echo '<script>alert("Data inserted successfully");window.location.href = "Confirm_order.php";</script>';
        exit;
    } else {
        echo "Error inserting data into the database: " . mysqli_error($connection);
    }
}
?>
