<?php
// Start the session (assuming you have started the session in your main PHP file)
session_start();

// Ensure that the request is a POST request and that the email_otp_input parameter is provided
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST["email_otp_input"])) {

  // Get the entered OTP from the POST data
  $enteredOTP = $_POST["email_otp_input"];

  // Retrieve the OTP from the session
  $savedOTP = isset($_SESSION['otp']) ? $_SESSION['otp'] : '';

  // Verify the entered OTP against the saved OTP
  if ($enteredOTP === $savedOTP) {
    // OTP verification successful
    echo json_encode(['success' => true]);
    // Optionally, you can unset the OTP from the session after successful verification
    // unset($_SESSION['otp']);
  } else {
    // Invalid OTP
    echo json_encode(['success' => false]);
  }
} else {
  echo json_encode(['success' => false]);
}




// $userOTP = $_POST['otp'];

// // Assume that the actual OTP for verification is stored in a session variable named 'otp_code'
// session_start();
// $otpCode = $_SESSION['otp_code'];

// // Compare the user-provided OTP with the actual OTP
// if ($userOTP == $otpCode) {
//     echo 'OTP verification successful!';
// } else {
//     echo 'OTP verification failed. Please try again.';
// }
?>
