<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
  <title>Document</title>

  <style>
    /* navbar */
    .navbar {
      position: fixed;
      top: 0;
      left: 245px;
      width: 100%;
      max-width: 150vh;
      height: 97px;
      background-color: white;
      display: flex;
      align-items: center;
      justify-content: space-between;
      padding: 15px 30px;
      z-index: 1000;
      box-shadow: 0 0 2px var(--grey-color-light);
      border-bottom: 2px solid #030040;
    }

    .logo_item {
      display: flex;
      align-items: center;
      column-gap: 10px;
      font-size: 22px;
      font-weight: 500;
      color: var(--blue-color);
    }

    .navbar img {
      width: 35px;
      height: 35px;
      border-radius: 50%;
    }

    .navbar_content {
      display: flex;
      align-items: center;
      column-gap: 25px;
    }

    .navbar_content i {
      cursor: pointer;
      font-size: 20px;
      color: var(--grey-color);
    }

    .logout-button,
    .reset-button {
      display: inline-block;
      padding: 8px 16px;
      color: white;
      background-image: radial-gradient(#da0000, #a70202);
      text-decoration: none;
      border-radius: 4px;
    }

    .logout-button:hover,
    .reset-button:hover {
      background-image: radial-gradient(#da0000, #a70202);
      color: white;
    }

    h1 {
      font-weight: 600;
      color: #030040;
    }

    p {
      color: #da0000;
      /* Fallback color for older browsers */
      color: #da0000;
      /* Your desired text color */
    }
    
    .hamburger {
  /* Add your desired positioning */
  position: absolute;
  top: 20px;
  left:50px;
}

/* Styles for the bars icon */
.fas.fa-bars {
  width:100px;
  height:40px;
  width: 50px;
  color: blue;
}

.active .sidebar{
	left: -225px;
}
.active  .navbar{
	margin-left: 0;
	width: 100%;
}

    /* Responsive Styles */
    @media only screen and (max-width: 1200px) {
      .navbar {
        left: 0;
      }
    }

    @media only screen and (max-width: 992px) {
      .navbar {
        padding: 15px;
      }
    }

    @media only screen and (max-width: 768px) {
      .logo_item {
        font-size: 18px;
      }

      .navbar_content i {
        font-size: 18px;
      }

      .logout-button,
      .reset-button {
        padding: 6px 12px;
        font-size: 14px;
      }
    }

    @media only screen and (max-width: 480px) and (min-width: 320px) {
      .logo_item {
        font-size: 16px;
      }

      .navbar img {
        width: 25px;
        height: 25px;
      }

      .navbar_content i {
        font-size: 16px;
      }

      .logout-button,
      .reset-button {
        padding: 4px 8px;
        font-size: 12px;
      }
    }
  </style>

</head>

<body>
  <!-- navbar -->
  <nav class="navbar">
      <div class="hamburger">
      <a href="#">
        <i class="fas fa-bars"></i>
      </a>
    </div><br>
    <div class="logo_item">
      <i class="bx bx-menu" id="sidebarOpen"></i>
      <h1>WELCOME</h1><p><h1> ADMIN !</h1></p>
    </div>
    <!-- <div class="search_bar">
      <input type="text" placeholder="Search" />
    </div> -->
    <div class="navbar_content">
      <i class="bi bi-grid"></i>
      <i class='bx bx-sun' id="darkLight"></i>
      <i class='bx bx-bell'></i>
      <a href="resetPassword.php" class="reset-button">Reset Password</a>
      <a href="logout.php" class="logout-button">Logout</a>
    </div>
  </nav>
</body>

</html>
