<?php
session_start();
// error_reporting(E_ALL);
// ini_set('display_errors', 1);
include('include/navigation.php');
include_once('connection.php');
include_once('class.php');
$dbConnection = new DbConnection();
$connection = $dbConnection->connection;

$list = new ConfirmOrder();
$fetch_dataCL = $list->getDataC_list();

// Check if $fetch_dataCL is not null and is an array
if (is_array($fetch_dataCL) && !empty($fetch_dataCL)) {
    $deliveryDates = [];
    foreach ($fetch_dataCL as $arr) {
        $deliveryDate = new DateTime($arr['d_month']);
        $deliveryDates[] = [
            'clientUID' => $arr['c_uid'],
            'productName' => $arr['q_do'],
            'deliveryDate' => $deliveryDate,
        ];
    }
} else {
    $deliveryDates = []; // Initialize an empty array to avoid errors if $fetch_dataCL is null or empty.
}
?>

         

<!DOCTYPE html>
<html lang="en">
<head>
  <link rel="stylesheet" type="text/css" href="include/css/list.css">

  <title>Document</title>
</head>
<body>
  <div class="container"><br><br><br>
  <div class="flexbox">
    <h2>Pending Order List</h2><br>
    <button class="reset-button" style="width:100px;"><a href="Order_delay_list.php">Delay List</a></button>
  </div><br>
<div>
  <table>
    <thead>
      <tr>
        <th>S.no</th>
        <th>Client UID</th>
        <th>Product Name</th>
        <th>Delivery Month</th>
        <th>Update Date</th>
                                  <?php
      if ($_SESSION['user']['roles'] === 'admin' || $_SESSION['user']['roles'] === 'user') {
               echo ' <th>Action</th>';
      }
?>
      </tr>
    </thead>
    <tbody>
                <?php $id = 1; ?>
                <?php foreach($fetch_dataCL as $arr): ?>
                <tr>
                  <td><?php echo $id; ?></td>
                  <td><?php echo $arr['c_uid']; ?></td>
                  <td><?php echo $arr['q_do']; ?></td>
                  <td><?php echo $arr['d_month']; ?></td>
                      <?php
      if ($_SESSION['user']['roles'] === 'admin' || $_SESSION['user']['roles'] === 'user') {
               echo '<td><a href="Pending_order_update.php?id='. $arr['id'].'?>" class="reset-button">Update</a></td>';
      }
?>
                  
                  
<td><a class="reset-button" href="javascript:void(0);" onclick="confirmSale('<?php echo htmlspecialchars($arr['c_uid']); ?>', '<?php echo htmlspecialchars($arr['q_do']); ?>', '<?php echo htmlspecialchars($arr['d_month']); ?>', '<?php echo htmlspecialchars($arr['total_amount']); ?>',  '<?php echo htmlspecialchars($arr['final_amount']); ?>','<?php echo htmlspecialchars($arr['amount_receive']); ?>', '<?php echo htmlspecialchars($arr['payment_mode']); ?>','<?php echo htmlspecialchars($arr['date']); ?>', '<?php echo htmlspecialchars($arr['bank_name']); ?>', '<?php echo htmlspecialchars($arr['total_amount_receive']); ?>', '<?php echo htmlspecialchars($arr['pending_amount']); ?>')">Sale</a></td>
                </tr>
                <?php $id++; ?>
                <?php endforeach; ?>
        </tbody>
      </table>    
    </div>
  </div>

  
<section class="footer">
    <?php include('include/footer_two.php') ?>
</section>
</body>

<?php   include('include/form_footer_link.php'); ?>

<script src="script/nav.js"></script>
<script>
function confirmSale(c_uid, q_do, d_month, total_amount, final_amount, amount_receive, payment_mode, date, bank_name, total_amount_receive, pending_amount) {
    var machine_uid = prompt("Please enter Machine Uid :");
    if (machine_uid === null) {
        return false; // User clicked "Cancel"
    }

    // Construct the confirmation message
    var confirmationMessage = "Are you sure you want to proceed with the sale?\n\n" +
        "Client UID: " + c_uid + "\n" +
        "Product Name: " + q_do + "\n" +
        "Delivery Month: " + d_month + "\n" +
        "Machine UID: " + machine_uid + "\n" +
        "Total: " + total_amount + "\n" +
        "Final Amount: " + final_amount + "\n" +
        "Amount Receive: " + amount_receive + "\n" +
        "Payment Mode: " + payment_mode + "\n" +
        "Date: " + date + "\n" +
        "Bank Name: " + bank_name + "\n" +
        "Total Amount Receive: " + total_amount_receive + "\n" +
        "Pending Amount: " + pending_amount;

    // Display a confirmation dialog
    var confirmation = confirm(confirmationMessage);

    if (confirmation) {
        // If the user confirms, construct the sale URL and navigate
        var saleUrl = `sales_done.php?c_uid=${c_uid}&q_do=${q_do}&d_month=${d_month}&total_amount=${total_amount}&final_amount=${final_amount}&amount_receive=${amount_receive}&payment_mode=${payment_mode}&date=${date}&bank_name=${bank_name}&total_amount_receive=${total_amount_receive}&pending_amount=${pending_amount}&machine_uid=${encodeURIComponent(machine_uid)}`;
        window.location.href = saleUrl;
    }

    return false; // Prevent the default form submission behavior
}


</script>
</html>