// javascript code of confim_order.php


     $(document).ready(function(){
        $('#name').selectpicker();
     })
     
var storedClientUID = "<?php echo $selectedClientUID; ?>";
var storedQuotation = "<?php echo $selectedQuotation; ?>";
var previousAmount = "<?php echo $previousAmount; ?>";

if (storedClientUID && storedQuotation) {
    document.getElementById("name").value = storedClientUID;
    document.getElementById("address").value = storedQuotation;
    document.getElementById("total-amount").value = previousAmount;
    // Optionally, trigger any additional logic you have on form elements
    document.getElementById("name").dispatchEvent(new Event("change"));
    document.getElementById("address").dispatchEvent(new Event("change"));
    document.getElementById("total-amount").dispatchEvent(new Event("change"));
}
document.addEventListener("DOMContentLoaded", function() {
    // Load selected values from localStorage
    var storedClientUID = localStorage.getItem("selectedClientUID");
    var storedQuotation = localStorage.getItem("selectedQuotation");

    // Set the selected values in the dropdowns
    if (storedClientUID && storedQuotation) {
        document.getElementById("name").value = storedClientUID;
        document.getElementById("address").value = storedQuotation;

        // Trigger change event to update other fields if needed
        document.getElementById("name").dispatchEvent(new Event("change"));
        document.getElementById("address").dispatchEvent(new Event("change"));
    }

    // Save selected values to localStorage on change
    document.getElementById("name").addEventListener("change", function() {
        localStorage.setItem("selectedClientUID", this.value);
    });

    document.getElementById("address").addEventListener("change", function() {
        localStorage.setItem("selectedQuotation", this.value);
    });
});

 function enableSecondDropdown() {
    var firstDropdown = document.getElementById("name");
    var secondDropdown = document.getElementById("address");

    if (firstDropdown.value !== "") {
        secondDropdown.removeAttribute("disabled");
    } else {
        secondDropdown.setAttribute("disabled", "true");
    }
}

function update_Total_AmountByQuotation(quotation) {
    $.ajax({
        url: 'amount_by_quotation.php',
        type: 'POST',
        data: { quotation: quotation },
        success: function (response) {
            try {
                var data = JSON.parse(response);
                $("#total-amount").val(data.total_amount);
                $("#total_amount_1").val(data.total_amount);
                $("#product_price").val(data.budget);
                $("#d_amount").val(data.d_amount);
                $("#gst").val(data.gst);
                $("#packaging").val(data.packaging);
                $("#tcs").val(data.tcs);
            } catch (e) {
                console.error("Error parsing JSON:", e);
                console.error("Invalid JSON response:", response);
            }
            hideForm(); // Optionally, hide the form
        },
        error: function (xhr, status, error) {
            console.error("AJAX Error:", error);
            console.error("Response Text:", xhr.responseText); // Log the response text
        }
    });
}

// Handle the change event of the "Quotation" dropdown
$(document).ready(function () {
    $('#address').change(function () {
        var selectedQuotation = $(this).val();
        if (selectedQuotation !== "") {
            update_Total_AmountByQuotation(selectedQuotation);
            enableSecondDropdown();
        } else {
            $("#total-amount").val("");
        }
    });
});


$(document).on('input', '.amount-receive', function () {
    updateTotalAmountReceived();
});

// Function to calculate and update the total amount received and pending amount
function updateTotalAmountReceived() {
    var totalAmountReceived = 0;

    // Loop through each "Amount Receive" input field and sum the values
    $('.amount-receive').each(function () {
        var value = parseFloat($(this).val()) || 0;
        totalAmountReceived += value;
    });

    // Update the total amount received field with the "Rs" prefix
    $('#Totalamount-receive').val('Rs ' + totalAmountReceived.toFixed(2));

    // Get the final amount with the "Rs" prefix
    var finalAmountWithPrefix = $('#final_amount').val() || 'Rs 0.00';

    // Extract numerical part of the final amount
    var finalAmount = parseFloat(finalAmountWithPrefix.replace(/[^0-9.]/g, '')) || 0;

    // Calculate and update the pending amount
    var pendingAmount = finalAmount - totalAmountReceived;

    // Update the pending amount field with the "Rs" prefix
    $('#pendingAmount').val('Rs ' + pendingAmount.toFixed(2));
}


// Function to clone and add fields
 function cloneAndAddFields() {
        var clonedFields = $("#addmore").clone(true, true); // Include event handlers when cloning
        clonedFields.find(".amount-receive").val(""); // Clear the values of the new input fields
        clonedFields.find(".date").val(""); // Clear the date values

        // Add a class to the cloned date input fields
        clonedFields.find(".date").addClass("cloned-date");

        // Bind the change event to the new date inputs
        clonedFields.find('.cloned-date').on('input', function () {
            updateTotalAmountReceived();
        });

        // Add a remove button for each set of cloned fields
        var removeButton = $('<button type="button" class="removeField">Remove</button>');
        clonedFields.append(removeButton);

        // Insert the cloned fields after the original fields
        $("#addmore").after(clonedFields);
    }

    // Handle the click event of the "Add More" button
    $("#addMoreAmount").click(function () {
        cloneAndAddFields();
    });

    // Handle the click event of the "Remove" button
    $(document).on('click', '.removeField', function () {
        $(this).parent().remove();
        updateTotalAmountReceived();
    });



function editQuotation() {
    var selectedClientUID = document.getElementById("name").value;
    var selectedQuotation = document.getElementById("address").value;
    var previousAmount = document.getElementById("total-amount").value;

    // Check if the form element exists before trying to access its properties
    var updateForm = document.getElementById("updateForm");
    if (updateForm) {
        // Toggle the visibility of the form
        if (updateForm.style.display === "block") {
            updateForm.style.display = "none";
        } else {
            updateForm.style.display = "block";
        }

        // Check if the form is visible, then hide the "EDIT" button
        var editButton = document.getElementById("editButton");
        if (editButton) {
            editButton.style.display = (updateForm.style.display === "block") ? "none" : "block";
        }
    } else {
        console.error("Element with id 'updateForm' not found.");
        return;
    }

    if (selectedClientUID && selectedQuotation) {
        // Set values in hidden input fields
        document.getElementById("cuid").value = selectedClientUID;
        document.getElementById("file-name").value = selectedQuotation;

        // Store the selected values in sessionStorage
        sessionStorage.setItem('selectedClientUID', selectedClientUID);
        sessionStorage.setItem('selectedQuotation', selectedQuotation);
        sessionStorage.setItem('previousAmount', previousAmount);

        // Uncomment the line below to redirect to the PHP script
        // window.location.href = 'c_damount_edit.php?client_uid=' + selectedClientUID + '&file_name=' + selectedQuotation;
    } else {
        // Handle the case where either the client UID or the quotation is not selected
        alert('Please select both Client UID and Quotation before editing.');
    }
}
function checkChequeStatus() {
    var clientId = document.getElementById("name").value;
    $.ajax({
        url: 'check_cheque_status.php',
        type: 'POST',
        data: { c_uid: clientId },
        success: function (response) {
            console.log("AJAX Response:", response);
            if (typeof response === 'object') {
                var chequeStatus = response.chequeStatus;
                if (chequeStatus === 2) {
                    $('#chequeOption').prop('disabled', true);
                } else {
                    $('#chequeOption').prop('disabled', false);
                }
            } else {
                console.error("Invalid JSON response:", response);
            }
        },
        error: function (xhr, status, error) {
            console.error("AJAX Error:", error);
        }
    });
}
// Function to hide the form
function hideForm() {
    var updateForm = document.getElementById("updateForm");
    if (updateForm) {
        updateForm.style.display = "none";
        var editButton = document.getElementById("editButton");
        if (editButton) {
            editButton.style.display = "block";
        }
    } else {
        console.error("Element with id 'updateForm' not found.");
    }
}
function calculateTotal() {
    // Add your calculation logic here
    // Example: Assuming product_price, d_amount, gst, packaging, and tcs are the IDs of your input fields
    var productPrice = parseFloat(document.getElementById("product_price").value) || 0;
    var discountAmount = parseFloat(document.getElementById("d_amount").value) || 0;
    var gst = parseFloat(document.getElementById("gst").value) || 0;
    var packaging = parseFloat(document.getElementById("packaging").value) || 0;
    var tcs = parseFloat(document.getElementById("tcs").value) || 0;

    var totalAmount = productPrice - discountAmount + gst + packaging + tcs;

    
    document.getElementById("total_amount_1").value = totalAmount.toFixed(2);
}