<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

include_once("connection.php");
$dbConnection = new DbConnection();
$connection = $dbConnection->connection;

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Retrieve data from the POST request
    $client_uid = $_POST['client_uid'];
    $product_name = $_POST['product_name'];
    $firm_name = $_POST['firm_name'];
    $machine_uid = $_POST['machine_uid'];
    $start_date = $_POST['start_date'];
    $end_date = $_POST['end_date'];

    // Prepare and execute the SQL INSERT statement
    $sql = "INSERT INTO warranty_start (client_uid, product_name, firm_name, machine_uid, start_date, end_date) 
            VALUES (:client_uid, :product_name, :firm_name, :machine_uid, :start_date, :end_date)";

    $stmt = $connection->prepare($sql);
    $stmt->bindParam(':client_uid', $client_uid);
    $stmt->bindParam(':product_name', $product_name);
    $stmt->bindParam(':firm_name', $firm_name);
    $stmt->bindParam(':machine_uid', $machine_uid);
    $stmt->bindParam(':start_date', $start_date);
    $stmt->bindParam(':end_date', $end_date);

    try {
        $stmt->execute();
        echo "Data inserted successfully";
    } catch (PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
} else {
    echo "Invalid request method";
}

// Close the database connection
$connection = null;
?>
