<?php
session_start();
include_once("connection.php");
error_reporting(E_ALL);
ini_set('display_errors', 1);


$dbConnection = new DbConnection();
$connection = $dbConnection->connection;

$response = array(); // Initialize response array

// Check if the user ID and name are provided via POST and if the user is logged in
if (isset($_POST['id']) && isset($_SESSION['user']['id']) && isset($_POST['name']) && isset($_SESSION['user']['name'])) {
    $uid = $_SESSION["user"]['id'];
    $uname = $_SESSION["user"]['name'];

    // Check if the user exists
    $check_sql = "SELECT id FROM users WHERE id = ? AND name = ?";
    $check_stmt = $connection->prepare($check_sql);
    if ($check_stmt) {
        $check_stmt->bind_param("is", $uid, $uname);
        $check_stmt->execute();
        $check_stmt->store_result();

        if ($check_stmt->num_rows > 0) {
            // User exists, proceed with the update query
            $sql = "UPDATE users SET status = NOW() WHERE id = ? AND name = ?";
            $stmt = $connection->prepare($sql);
            if ($stmt) {
                $stmt->bind_param("is", $uid, $uname);

                if ($stmt->execute()) {
                    if ($stmt->affected_rows > 0) {
                        $response['success'] = true;
                    } else {
                        $response['success'] = false;
                        $response['error'] = 'No rows affected';
                    }
                } else {
                    $response['success'] = false;
                    $response['error'] = 'Error executing the query: ' . $stmt->error;
                }

                // Close statement
                $stmt->close();
            } else {
                $response['success'] = false;
                $response['error'] = 'Error preparing the query: ' . $connection->error;
            }
        } else {
            // User does not exist
            $response['success'] = false;
            $response['error'] = 'User does not exist';
        }

        // Close check statement
        $check_stmt->close();
    } else {
        $response['success'] = false;
        $response['error'] = 'Error preparing the query: ' . $connection->error;
    }
} else {
    $response['success'] = false;
    $response['error'] = 'User ID or name not provided or user not logged in';
}

// Send response as JSON
echo json_encode($response);
exit(); // Terminate the script to prevent any additional output
?>
