<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

include('include/navigation.php');
include_once("connection.php");
$dbConnection = new DbConnection();
$connection = $dbConnection->connection;

// Check if the required parameters are set
if (isset($_GET['c_uid']) && isset($_GET['q_do']) && isset($_GET['updated_on']) && isset($_GET['machine_uid'])) {
    $c_uid = mysqli_real_escape_string($connection, $_GET['c_uid']);
    $q_do = mysqli_real_escape_string($connection, $_GET['q_do']);
    $w_month = mysqli_real_escape_string($connection, $_GET['updated_on']);
    $machine_uid = mysqli_real_escape_string($connection, $_GET['machine_uid']);

    $query = "SELECT * FROM sales WHERE c_uid = '$c_uid' AND q_do = '$q_do' AND updated_on = '$w_month'";
    $result = mysqli_query($connection, $query);

    if ($result) {
        $row = mysqli_fetch_assoc($result);

        // Fetch Firm Name from clients table
        $clientQuery = "SELECT firm_name FROM clients WHERE u_id = '$c_uid'";
        $clientResult = mysqli_query($connection, $clientQuery);

        if ($clientResult) {
            $clientRow = mysqli_fetch_assoc($clientResult);

            // Assign Firm Name to a variable
            $firmName = $clientRow['firm_name'];
        } else {
            die('Error in client query: ' . mysqli_error($connection));
        }
    } else {
        die('Error in query: ' . mysqli_error($connection));
    }
} else {
    die('Missing parameters');
}

$startDate = $row['updated_on'];

$warrantyEndDate = date('Y-m-d', strtotime($startDate . ' + 3 months'));
$initialEndDate = $warrantyEndDate;
$phoneNumber = "+919915200537";
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sales List</title>
    <link rel="stylesheet" href="include/css/list.css">
    <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

<style>
        .disabled-undo {
            background-color: #b5e7a0;
        }
        .highlighted-date {
            background-color: yellow;
        }
    </style>
</head>
<body>
    <div class="container"><br><br><br>
        <div class="flexbox">
            <center>
                <h2> Warranty Action</h2>
                    

            </center>
        </div><br>
         <button class="reset-button"><a href="Sales_list.php"><i class="fa-solid fa-backward"></i></a></button>
        <div>
            <table>
                <col>
                <colgroup span="1"></colgroup>
                
                <tr>
                    <th scope="colgroup"><button class="reset-button" id="autoRenewBtn" style="width:auto;height:auto;"><a href="#">Auto Renew</a></button>
                    <div id="recaptcha_container1"></div>
                    </th>
                    <th scope="colgroup">
                   <button class="reset-button" id="manualRenewBtn" onclick="showForm()" style ="width:auto;height:auto">Manual Renew</button>
                    <div id="renewForm" style="display: none;">
                      <!-- Yahan aap apna form add kar sakte hain -->
                      <form action="warantee_manual_renue.php" method="POST">
                          <input type = "text" value ="" name="client_uid"hidden >
                          <input type = "text" value ="" name="product_name"hidden><br>
                          <input type = "text" value ="" name="firm_name" hidden>
                          <input type = "text" value ="" name="machine_uid" hidden>
                          <input type = "text" value ="" name="start_date" required ><br>
                        <input type="" placeholder="click here for calender" value="" name="end_date" id="endDateInput" required><br>
                         <div id="recaptcha-container"></div>
                         <button class="reset-button" id="saveBtn" name="submit" onclick="" style="width:auto;">save</button>
                         
                          
                      </form>
                    </div>
                                            
                </th>
                </tr>
                <tr>
                    <th scope="col">Client Uid</th>
                    <td><?php echo $row['c_uid']; ?></td>
                </tr>
                <tr>
                    <th scope="row">Firm Name</th>
                    <td><?php echo $firmName; ?></td>
                </tr>
                <tr>
                    <th scope="row">Product Name</th>
                    <td><?php echo $row['q_do']; ?></td>
                </tr>
                <tr>
                    <th scope="row">Machine UID</th>
                    <td><?php echo $row['machine_uid']; ?></td>
                </tr>
                <tr>
                    <th scope="row">1st Warranty Date</th>
                    <td><?php echo $row['updated_on']; ?></td>
                </tr>
                <tr>
                    <th scope="row">1st Warranty End Date</th>
                    <td id="manualEndDate"><?php echo $warrantyEndDate; ?></td>
                </tr>
             <?php
                $query = "SELECT start_date, end_date FROM warranty_start WHERE client_uid='$c_uid' AND machine_uid='$machine_uid'";
                $result = mysqli_query($connection, $query);
                
                // Check if the query was successful
                if ($result) {
                    
                    
                    while ($row = mysqli_fetch_assoc($result)) {
                        echo "<tr>";
                        echo "<th>Warranty Start Date</th>";
                        echo "<td>" . $row['start_date'] . "</td>";
                        echo "</tr>";
                
                        echo "<tr>";
                        echo "<th>Warranty End Date</th>";
                        echo "<td>" . $row['end_date'] . "</td>";
                        echo "</tr>";
                    }
                
                    
                } else {
                    echo "Error in query: " . mysqli_error($connection);
                }
                ?>
    </table>
        </div>
    </div>
</body>
    <!-- Include jQuery and datepicker script -->
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
<script src="https://www.gstatic.com/firebasejs/8.3.2/firebase-app.js"></script>
<script src="https://www.gstatic.com/firebasejs/8.3.2/firebase-auth.js"></script>
<script src="https://www.gstatic.com/firebasejs/8.3.2/firebase-analytics.js"></script>
<script src="https://www.google.com/recaptcha/api.js" async defer></script>
<script>
  
var firebaseConfig = {
    apiKey: "AIzaSyC4CPeblurZtNPA5l6NZqN3LarA6vyA8K8",
    authDomain: "mobile-otp-d6be3.firebaseapp.com",
    projectId: "mobile-otp-d6be3",
    storageBucket: "mobile-otp-d6be3.appspot.com",
    messagingSenderId: "86771985887",
    appId: "1:86771985887:web:5f35d64d12bdf7d7d0686a",
    measurementId: "G-G3TPGL0NP3"
};

     // Initialize Firebase
        firebase.initializeApp(firebaseConfig);
        
var cUid = "<?= $c_uid ?>";
var firmName = "<?= $firmName ?>";
var productName = "<?= $q_do ?>";
var machineUid = "<?= $machine_uid ?>";
var startDate;
var endDate;

        // Auto Renew button click event
$("#autoRenewBtn").on("click", function () {
    var phoneNumber = "+919915200537";
    sendOTPWithFirebase(phoneNumber);
    return false;
});
        

        // Function to send OTP with Firebase
function sendOTPWithFirebase(phoneNumber) {
    // Render RecaptchaVerifier before sending OTP
    var appVerifier = new firebase.auth.RecaptchaVerifier('recaptcha_container1');
    appVerifier.render();

    // Sign in with phone number and render RecaptchaVerifier
    firebase.auth().signInWithPhoneNumber(phoneNumber, appVerifier)
        .then(function (confirmationResult) {
            window.confirmationResult = confirmationResult;

            // After OTP is sent, show a prompt to enter OTP
            var userEnteredOTP = prompt("Enter the OTP sent to your phone:");

            if (userEnteredOTP) {
                verifyOTPWithFirebase(userEnteredOTP).then(function (verified) {
                    if (verified) {
                        // Get the last end_date from the server
                        getLastEndDateFromServer().then(function (lastEndDate) {
                            // Now you have the last end_date, proceed with calculations
                            var startDate = new Date(lastEndDate);
                            startDate.setDate(startDate.getDate() + 1); // Add 1 day
                            var endDate = new Date(startDate);
                            endDate.setDate(endDate.getDate() + 90);

                            // Format the start and end dates as 'YYYY-MM-DD'
                            var formattedStartDate = startDate.toISOString().split('T')[0];
                            var formattedEndDate = endDate.toISOString().split('T')[0];

                            // Update the last row in the table with the new start and end dates
                            $("#manualEndDate").text(formattedEndDate);

                            // Create a new row with the calculated dates
                            var newRow = '<tr><th scope="row">Warranty Start Date</th><td>' + formattedStartDate + '</td></tr>';
                            newRow += '<tr><th scope="row">Warranty End Date</th><td>' + formattedEndDate + '</td></tr>';

                            // Append the new row to the table
                            $("table").append(newRow);

                            // Collect additional data from the page
                            var cUid = "<?= $c_uid ?>";
                            var firmName = "<?= $firmName ?>";
                            var productName = "<?= $q_do ?>";
                            var machineUid = "<?= $machine_uid ?>";

                            // Send the calculated dates and additional data to the server for saving
                            saveToDatabase(cUid, firmName, productName, machineUid, formattedStartDate, formattedEndDate);

                            // Prevent default button behavior
                            return false;
                        }).catch(function (error) {
                            alert("Error fetching last end_date: " + error);
                        });
                    } else {
                        alert("Invalid OTP. Please try again.");
                    }
                });
            }
        })
        .catch(function (error) {
            alert("Error sending OTP: " + error.message);
        });
}
        // Function to get the last end_date from the server
function getLastEndDateFromServer() {
    return new Promise(function (resolve, reject) {
        $.ajax({
            url: 'warantee_getLastEndDate.php',
            type: 'GET',
            dataType: 'json',
            data: {
                c_uid: cUid,
                firmName: firmName,
                productName: productName,
                machineUid: machineUid,
            },
            success: function (response) {
                // Log the response to the console
                console.log('AJAX Response:', response);

                // Resolve with the last end_date
                resolve(response.lastEndDate);
            },
            error: function (xhr, status, error) {
                // Log specific details about the AJAX error
                console.error("AJAX Error - Status:", status, "Error:", error, "Response Text:", xhr.responseText);
                reject('AJAX error');
            }
        });
    });
}
// Function to verify OTP with Firebase
function verifyOTPWithFirebase(userEnteredOTP) {
    return window.confirmationResult.confirm(userEnteredOTP)
        .then(function (result) {
            return true;
        })
        .catch(function (error) {
            alert("Invalid OTP. Please try again.");
            return false;
        });
}

// Function to save data to the database
function saveToDatabase(cUid, firmName, productName, machineUid, startDate, endDate) {
    console.log('Save to Database - Parameters:', cUid, firmName, productName, machineUid, startDate, endDate);

    // Send the data to the server using AJAX
   $.ajax({
    type: "POST",
    url: "warantee_auto_renue.php",
    data: {
        c_uid: cUid,
        firmName: firmName,
        productName: productName,
        machineUid: machineUid,
        start_date: startDate,
        end_date: endDate
    },
    success: function (response) {
        alert("Warranty renewed successfully");
        // location.reload(); // Reload the page
    },
    error: function (xhr, status, error) {
        // Handle any errors that occur during the AJAX request
        alert("AJAX Error: " + error);
    }
});
}















// for manually renue 
function showForm() {
  var form = document.getElementById("renewForm");
  form.style.display = "block";
}

document.addEventListener('DOMContentLoaded', function() {
  // Get the form elements
  var form = document.querySelector('form');
  var clientUidInput = form.querySelector('input[name="client_uid"]');
  var productNameInput = form.querySelector('input[name="product_name"]');
  var firmNameInput = form.querySelector('input[name="firm_name"]');
  var machineUidInput = form.querySelector('input[name="machine_uid"]');
  var startDateInput = form.querySelector('input[name="start_date"]');
  var endDateInput = form.querySelector('input[name="end_date"]');

  // Set the values for the hidden fields
  clientUidInput.value = "<?php echo $c_uid; ?>";
  productNameInput.value = "<?php echo $q_do; ?>";
  firmNameInput.value = "<?php echo $firmName; ?>";
  machineUidInput.value = "<?php echo $machine_uid; ?>";

  // Calculate and set the start_date from the last row's date
  var table = document.querySelector('table');
  var lastRow = table.rows[table.rows.length - 1];
  var lastRowDateCell = lastRow.cells[1]; // Assuming the date cell is in the second column (index 1)

  if (lastRowDateCell) {
    var lastRowDate = new Date(lastRowDateCell.textContent);
    lastRowDate.setDate(lastRowDate.getDate() + 1);
    var formattedStartDate = lastRowDate.toISOString().slice(0, 10);
    startDateInput.value = formattedStartDate;
  }

  // Initialize datepicker with start_date value
  $("#endDateInput").datepicker({
    dateFormat: "yy-mm-dd",
    minDate: startDateInput.value, // Set the minimum selectable date
  });
});

var cUid = "<?php echo $c_uid; ?>";
var firmName; // Define firmName in the outer scope
var productName;
var machineUid;
var startDate;
var endDate;

var phoneNumber = "+919915200537";
sendOTP(phoneNumber);

function sendOTP(phoneNumber) {
    var recaptchaVerifier = new firebase.auth.RecaptchaVerifier('recaptcha-container');

    firebase
        .auth()
        .signInWithPhoneNumber(phoneNumber, recaptchaVerifier)
        .then(function (confirmationResult) {
            var verificationId = prompt('Please enter the verification code sent to your phone:');

            return confirmationResult.confirm(verificationId);
        })
        .then(function (result) {
            console.log('Phone number verified successfully');
            // Once verified, call the function to save to the database
            // saveToDatabase(cUid, firmName, productName, machineUid, startDate, endDate);
        })
        .catch(function (error) {
            console.error('Error verifying phone number:', error.message);
            alert('Phone number verification failed: ' + error.message);
        });
}

$("#saveBtn").on("click", function () {
    var phoneNumber = "+919915000537";
    sendOTP(phoneNumber);
    $.ajax({
        type: "POST",
        url: "warantee_manual_renue.php",
        data: {
            c_uid: cUid,
            firmName: firmName,
            productName: productName,
            machineUid: machineUid,
            start_date: startDate,
            end_date: endDate
        },
        success: function (response) {
            alert("otp verification sucessfull");
        },
        error: function (xhr, status, error) {
            alert("AJAX Error: " + error);
        }
    });

  });
</script>
</html>
