<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

include_once("connection.php");
$dbConnection = new DbConnection();
$connection = $dbConnection->connection;

if (!$connection) {
    $response = ['success' => false, 'error' => 'Database connection error: ' . mysqli_connect_error()];
    echo json_encode($response);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    try {
        // Parse input data from the AJAX request
        $clientUid = $_GET['c_uid'];
        $firmName = $_GET['firmName'];
        $productName = $_GET['productName'];
        $machineUid = $_GET['machineUid'];

        // Perform a query to get the last row's end_date from warranty_start
        $query = "SELECT end_date FROM warranty_start WHERE client_uid='$clientUid' AND firm_name='$firmName' AND product_name='$productName' AND machine_uid='$machineUid' ORDER BY end_date DESC LIMIT 1";

        // Check if the query execution was successful
        $result = mysqli_query($connection, $query);

        if (!$result) {
            throw new Exception('Unable to execute query: ' . mysqli_error($connection));
        }

        // Check if rows are found
        if (mysqli_num_rows($result) > 0) {
            $row = mysqli_fetch_assoc($result);
            $lastEndDate = $row['end_date'];
            $response = ['success' => true, 'lastEndDate' => $lastEndDate];
            echo json_encode($response);
        } else {
            $response = ['success' => false, 'error' => 'No rows found'];
            echo json_encode($response);
        }
    } catch (Exception $e) {
        $response = ['success' => false, 'error' => 'Error: ' . $e->getMessage()];
        echo json_encode($response);
    }

    // Close the database connection
    mysqli_close($connection);
}
?>
