<?php
include('include/session.php');
// session_start();

// Set error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);


include('connection.php');
include('class.php');

// Establish database connection
$dbConnection = new DbConnection();
$connection = $dbConnection->connection;

// Redirect if user is already logged in
if (isset($_SESSION["id"])) {
    header("Location: _order_list.php");
    exit;
}

// Initialize Orders object
$Orders = new NewOrder();

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    // Check if all required fields are submitted
    if (
        isset($_POST["category"], $_POST["product"], $_POST["variation"], $_POST["product_id"], 
        $_POST["price"], $_POST["quantity"], $_POST["quality_check_pass"], $_POST["quality_check_no"])
    ) {
        // Prepare and execute the queries for each entry
        foreach ($_POST["category"] as $index => $category) {
            $product = $_POST["product"][$index];
            $variation = $_POST["variation"][$index];
            $product_id = $_POST["product_id"][$index];
            $price = $_POST["price"][$index];
            $quantity = $_POST["quantity"][$index];
            $quality_check_pass = $_POST["quality_check_pass"][$index];
            $quality_check_fail = $_POST["quality_check_no"][$index];

         // Prepare and execute the query for arrival_store table
            $query = "INSERT INTO arrival_store (category, product, variation, product_id, price, quantity, quality_check_pass, quality_check_no) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
            $stmt = mysqli_prepare($connection, $query);
            mysqli_stmt_bind_param($stmt, "ssssssss", $category, $product, $variation, $product_id, $price, $quantity, $quality_check_pass, $quality_check_fail);
            $result = mysqli_stmt_execute($stmt);
            // echo print_r($result);
            // If insertion to arrival_store is successful, insert into other tables
            if ($result) {
                $categoryQuery = "INSERT INTO category (category) VALUES (?)";
                $productQuery = "INSERT INTO product (category, product) VALUES (?, ?)";
                $productVariationQuery = "INSERT INTO product_variation (product, variation, product_id, price, quantity) VALUES (?, ?, ?, ?, ?)";

                $stmt1 = mysqli_prepare($connection, $categoryQuery);
                mysqli_stmt_bind_param($stmt1, "s", $category);
                mysqli_stmt_execute($stmt1);
                mysqli_stmt_close($stmt1);

                $stmt2 = mysqli_prepare($connection, $productQuery);
                mysqli_stmt_bind_param($stmt2, "ss", $category, $product);
                mysqli_stmt_execute($stmt2);
                mysqli_stmt_close($stmt2);

                $stmt3 = mysqli_prepare($connection, $productVariationQuery);
                mysqli_stmt_bind_param($stmt3, "sssss", $product, $variation,$product_id, $price, $quantity);
                mysqli_stmt_execute($stmt3);
                mysqli_stmt_close($stmt3);
            } else {
                echo "<script> alert('Error: Failed to add entry.'); </script>";
            }

            mysqli_stmt_close($stmt);
        }
        echo "<script> alert('Entries Added Successfully'); window.location='_arrival_store.php'; </script>";
    } else {
        echo "<script> alert('Error: Form fields are not properly submitted.'); </script>";
    }
}
?>
