<?php
include('include/session.php');
include('connection.php');
$dbConnection = new DbConnection();
$connection = $dbConnection->connection;

// Check if the category parameter is set
if (isset($_GET['product'])) {
    $selectedProduct = $_GET['product'];

    // Use prepared statements to prevent SQL injection
    $sql = "SELECT variation FROM procurement WHERE product=?";
    $stmt = $connection->prepare($sql);
    $stmt->bind_param("s", $selectedProduct); // Only one parameter is needed
    $stmt->execute();
    $result = $stmt->get_result();

    // Check if there are rows in the result
    if ($result->num_rows > 0) {
        echo '<option value="">' . "Select Variation" . '</option>';
        while ($row = $result->fetch_assoc()) {
            echo '<option value="' . $row["variation"] . '">' . $row["variation"] . '</option>';
        }
    } else {
        // No products found for the selected category
        echo '<option value="">No variation Found</option>';
    }

    // Close the prepared statement
    $stmt->close();
} else {
    // If category parameter is not set
    echo '<option value="">Select Product First</option>';
}

// Close the database connection
$connection->close();
?>
