<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
include('include/session.php');
include('include/navigation.php');
include('connection.php');
include('class.php');


// Initialize database connection
$dbConnection = new DbConnection();
$connection = $dbConnection->connection;

// Fetch parameters from the query string
$id = isset($_GET["id"]) ? intval($_GET["id"]) : 0;
$product = isset($_GET["product"]) ? $connection->real_escape_string($_GET["product"]) : '';

// Create an instance of NewOrder
$onerecord = new NewOrder();
$sql = $onerecord->Stockfetchonerecord($id, $product);

if ($sql instanceof mysqli_result && $row = $sql->fetch_assoc()) {
    // Fetch categories for the select box
    $category_sql = "SELECT DISTINCT category FROM category ORDER BY category";
    $category_result = $connection->query($category_sql);

    if ($category_result === false) {
        die("Error fetching categories: " . $connection->error);
    }
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <link rel="stylesheet" href="assets/css/style.css">
        <?php include('include/header_links.php'); ?>
    </head>
    <style>
        .variation_form {
            width: 100%;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .form-group {
            width: 100%;
        }
        .variation_button {
            display: flex;
            justify-content: center;
        }
        #clientUid {
            width: 80%;
        }
    </style>
    <body>
        <div class="container_main">
            <h1>Edit Product</h1>
            <div id="warantee_button">
                <div class="item-left">
                    <button class="reset-button"><a href="_stock_list.php"><i class="fa-solid fa-backward"></i></a></button>
                </div>
                <div class="reset-button item-right"><a href="_order_list.php">Order Summary</a></div>
            </div>

            <form action="" method="POST">
                <!-- Hidden input for ID -->
                <input type="hidden" name="id" value="<?php echo htmlspecialchars($row['id']); ?>">

               

                <div class="form-group">
                    <h3>Update Product Variation</h3><br>

                    <!-- Product Selection -->
                    <div class="form-group row">
                        <label for="productSelect" class="col-sm-2 col-form-label"><h5>Select Product:</h5></label>
                        <div class="col-sm-10">
                            <select data-live-search="true" class="form-control" name="product" id="productSelect">
                                <option value="">Select Product</option>
                                <?php
                                $product_sql = "SELECT * FROM product ORDER BY category";
                                $product_result = $connection->query($product_sql);
                                if ($product_result->num_rows > 0) {
                                    $current_category = "";
                                    while ($product_row = $product_result->fetch_assoc()) {
                                        if ($current_category != $product_row['category']) {
                                            if ($current_category != "") {
                                                echo '</optgroup>';
                                            }
                                            echo '<optgroup label="' . htmlspecialchars($product_row["category"]) . '">';
                                            $current_category = $product_row['category'];
                                        }
                                        $selected = ($product_row['product'] == $row['product']) ? ' selected' : '';
                                        echo '<option value="' . htmlspecialchars($product_row["product"]) . '"' . $selected . '>' . htmlspecialchars($product_row["product"]) . '</option>';
                                    }
                                    echo '</optgroup>';
                                } else {
                                    echo '<option value="">No products available</option>';
                                }
                                ?>
                            </select>
                        </div>
                    </div>

                    <!-- Product Variation -->
                    <div class="form-group row">
                        <label for="variation" class="col-sm-2 col-form-label"><h5>Product Variation:</h5></label>
                        <div class="col-sm-10">
                            <input type="text" id="variation" class="form-control" placeholder="Enter Product variation" aria-label="Text input with segmented dropdown button" name="variation" value="<?php echo htmlspecialchars($row['variation'] ?? ''); ?>" required>
                        </div>
                    </div>

                    <!-- Product Id -->
                    <div class="form-group row">
                        <label for="productId" class="col-sm-2 col-form-label"><h5>Product Id:</h5></label>
                        <div class="col-sm-10">
                            <input type="text" id="productId" class="form-control" placeholder="Enter Product Id" aria-label="Text input with segmented dropdown button" name="product_id" value="<?php echo htmlspecialchars($row['product_id'] ?? ''); ?>" required>
                        </div>
                    </div>

                    <!-- Price -->
                    <div class="form-group row">
                        <label for="price" class="col-sm-2 col-form-label"><h5>Price:</h5></label>
                        <div class="col-sm-10" style="display:flex;">
                            <input type="text" class="form-control" value="Rs. " aria-label="Text input with segmented dropdown button" name="" style="width:10%;">
                            <input type="text" id="price" class="form-control" placeholder="Enter Price" aria-label="Text input with segmented dropdown button" name="price" value="<?php echo htmlspecialchars($row['price'] ?? ''); ?>" required>
                        </div>
                    </div>

                    <!-- Quantity -->
                    <div class="form-group row">
                        <label for="quantity" class="col-sm-2 col-form-label"><h5>Quantity:</h5></label>
                        <div class="col-sm-10">
                            <input type="text" id="quantity" class="form-control" placeholder="Enter Quantity" aria-label="Text input with segmented dropdown button" name="quantity" value="<?php echo htmlspecialchars($row['quantity'] ?? ''); ?>" required>
                        </div>
                    </div>

                    <div class="variation_button">
                        <button type="submit" class="btn btn-outline-secondary" name="update">Update</button>
                    </div>
                </div>
            </form>
        </div>

        <section class="footer">
            <?php include_once("include/footer_two.php"); ?>
        </section>
    </body>
    <?php include("include/footer_link.php"); ?>
    <script src="assets/script/script.js"></script>
    </html>



    <?php
} else {
   
    echo "Error: " . $connection->error;
}
if (isset($_POST['update'])) {
    // Extract and sanitize form data
    $id = intval($_POST['id']); // Ensure this is coming from the hidden input field
    $product = trim($_POST['product']);
    $category = trim($_POST['category']);
    $variation = trim($_POST['variation']);
    $product_id = trim($_POST['product_id']);
    $price = trim($_POST['price']);
    $quantity = trim($_POST['quantity']);

    // Create an instance of NewOrder and call the updateProduct method
    $updatedata = new NewOrder();
    $updateResult = $updatedata->updateProduct($product, $category, $variation, $product_id, $price, $quantity, $id);

    // Check the result of the update operation
    if ($updateResult) {
        echo "<script>alert('Record updated successfully'); window.location.href='_stock_list.php';</script>";
    } else {
        echo "<script>alert('Error updating record');</script>";
    }
}



?>
