<?php
// Include necessary files
include('connection.php'); // Your database connection file
include('include/session.php'); // To check if the user is logged in (if applicable)
 // For navigation (if applicable)

// Initialize database connection
$dbConnection = new DbConnection();
$connection = $dbConnection->connection;

// Check if the 'id' parameter is set
if (isset($_GET['id'])) {
    // Sanitize the ID
    $id = intval($_GET['id']);

    // Prepare the SQL delete query
    $deleteProductQuery = "DELETE FROM `product_variation` WHERE `id`=?";
    $stmt = $connection->prepare($deleteProductQuery);

    if ($stmt) {
        // Bind the ID parameter and execute the query
        $stmt->bind_param('i', $id);
        $deleteResult = $stmt->execute();

        if ($deleteResult) {
            // Successfully deleted
            echo "<script>alert('Product deleted successfully'); window.location.href='_stock_list.php';</script>";
        } else {
            // Error occurred
            echo "<script>alert('Error deleting product: " . $stmt->error . "'); window.location.href='_stock_list.php';</script>";
        }

        // Close the statement
        $stmt->close();
    } else {
        // Prepare statement failed
        echo "<script>alert('Error preparing statement: " . $connection->error . "'); window.location.href='_stock_list.php';</script>";
    }
} else {
    // ID not provided
    echo "<script>alert('No product ID specified'); window.location.href='_stock_list.php';</script>";
}

// Close the database connection
$connection->close();
?>
