<?php
include('include/session.php');
include('connection.php');
$dbConnection = new DbConnection();
$connection = $dbConnection->connection;

// Check if the category parameter is set
if (isset($_GET['category'])) {
    $selectedCategory = $_GET['category'];

    // Use prepared statements to prevent SQL injection
    $sql = "SELECT product FROM (
                SELECT product FROM product WHERE category = ? 
                UNION 
                SELECT product FROM arrival_store WHERE category = ?
            ) AS combined_products";
    $stmt = $connection->prepare($sql);
    $stmt->bind_param("ss", $selectedCategory, $selectedCategory);
    $stmt->execute();
    $result = $stmt->get_result();

    // Check if there are rows in the result
    if ($result->num_rows > 0) {
        echo '<option value="">' . "Select Product" . '</option>';
        while ($row = $result->fetch_assoc()) {
            echo '<option value="' . $row["product"] . '">' . $row["product"] . '</option>';
        }
    } else {
        // No products found for the selected category
        echo '<option value="">No Products Found</option>';
    }

    // Close the prepared statement
    $stmt->close();
} else {
    // If category parameter is not set
    echo '<option value="">Select Category First</option>';
}

// Close the database connection
$connection->close();
?>
