<?php
ob_start();
include('include/session.php');
// session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Set session maximum lifetime to 8 hours
ini_set('session.gc_maxlifetime', 28800);

include('connection.php');
include('class.php');

$dbConnection = new DbConnection();
$user = new User($dbConnection->connection);

// Rest of your code...
if (isset($_POST['login'])) {
    $email = $_POST['email'];
    $password = $_POST['password'];

    // Check login logic
    $auth = $user->check_login($email, $password);

    if (!$auth) {
        $_SESSION['message'] = 'Invalid username or password';
        header('location: index.php');
        exit;
    } else {
        // Assuming $auth is an associative array with user data
        $_SESSION['user'] = $auth;
        $_SESSION['name'] = $auth['name'];
        header('location: dashboard.php');
        exit;
    }
} else {
    $_SESSION['message'] = 'You need to login first';
    header('location: index.php');
    exit;
}

?>