<?php
include('include/session.php');
include('connection.php');
$dbConnection = new DbConnection();
$connection = $dbConnection->connection;
// Check if the request method is POST
// Check if the request method is POST
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Retrieve the data sent via POST
    $updatedStock = $_POST['quantity']; // Assuming this is the quantity field
    $variation = $_POST['variation']; // Assuming this is the variation field

    // Prepare the SQL statement to update the stock
    $sql = "UPDATE product_variation SET quantity = ? WHERE variation = ?";

    // Prepare and bind parameters
    $stmt = $connection->prepare($sql);
    $stmt->bind_param("is", $updatedStock, $variation);

    // Execute the statement
    if ($stmt->execute()) {
        // Database update successful
        $response = array('status' => 'success', 'message' => 'Data updated successfully');
        echo json_encode($response);
    } else {
        // Database update failed
        $response = array('status' => 'error', 'message' => 'Error updating data: ' . $connection->error);
        echo json_encode($response);
    }

    // Close the statement
    $stmt->close();
} else {
    // If the request method is not POST, return an error
    $response = array('status' => 'error', 'message' => 'Invalid request method');
    echo json_encode($response);
}
?>

