<?php
include('include/session.php');
// session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

include('include/navigation.php');
include('connection.php');
include('class.php');

// Establish database connection
$dbConnection = new DbConnection();
$connection = $dbConnection->connection;

?>

<html lang="en">
<head>
    <link rel="stylesheet" href="assets/css/style.css">
    <?php include('include/header_links.php'); ?>
</head>
<style>

</style>
<body>
    <div class="container_main">
         <div id="warantee_button">
                    <div> <button class="reset-button"><a href="weekly_reports.php"><i class="fa-solid fa-backward"></i></a></button></div>
                    
                </div>
     <h1>-- Week Five Sales Reports--</h1>
   
        <table class="table table-striped">
            <thead>
                <tr>
                    <th scope="col" colspan="6">Total Sales</th>
                </tr>
                <tr>
                    <th scope="col">Category</th>
                    <th scope="col">Product</th>
                    <th scope="col">Variation</th>
                    <th scope="col">Price</th>
                    <th scope="col">Quantity</th>
                    <th scope="col">Total Amount</th>
                </tr>
            </thead>
            <tbody>
                <?php
                // Get current date range (from 1st to 7th day of the current month)
                $currentMonth = date('m');
                $currentYear = date('Y');
                $startDate = date('Y-m-d', strtotime("$currentYear-$currentMonth-29"));
                $endDate = date('Y-m-d', strtotime("$currentYear-$currentMonth-31"));
                
                $query = "SELECT * FROM order_summery WHERE DATE(created_on) BETWEEN '$startDate' AND '$endDate'";
                $result = mysqli_query($connection, $query);
                
                $totalSales = 0; // Variable to hold the total sales amount
                
                if ($result && mysqli_num_rows($result) > 0) {
                    while ($row = mysqli_fetch_assoc($result)) {
                        echo "<tr>";
                        // Outputting table data
                        echo '<td>' . implode("<br>", explode(",", $row['category'])) . '</td>';
                        echo '<td>' . implode("<br>", explode(",", $row['product'])) . '</td>';
                        echo '<td>' . implode("<br>", explode(",", $row['variation'])) . '</td>';
                        echo '<td>' . implode("<br>", explode(",", $row['price'])) . '</td>';
                        echo "<td>{$row['items']}</td>";
                        
                        // Remove currency symbol and non-numeric characters from total_price
                        $totalPrice = preg_replace('/[^0-9.]/', '', $row['total_price']);
                        
                        echo "<td>{$totalPrice}</td>";
                        echo "</tr>";
                        
                        // Calculating total sales
                        $totalSales +=  preg_replace('/[^0-9.]/', '', floatval($totalPrice));
                    }
                } else {
                    echo "<tr><td colspan='6'>No sales Found</td></tr>";
                }
                ?>
                <tr>
                    <td colspan="5" style="text-align: right;"><strong>Total Sales:</strong></td>
                    <td><?php echo "Rs " . number_format($totalSales, 2); ?></td>
                </tr>
            </tbody>
        </table>
     </div>
     <section class="footer">
     <?php include('include/footer_two.php');         ?>
     
 </section>
</body>
<?php include("include/footer_link.php"); ?>
<script src="assets/script/script.js"></script>
</html>
